/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.utils;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.Environment;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLogger;

public class SpamFilter {
    public static final WikiLogger logger = WikiLogger.getLogger(SpamFilter.class.getName());
    public static final String SPAM_BLACKLIST_FILE = "spam-blacklist.txt";
    private static Pattern spamRegexPattern = null;

    private SpamFilter() {
    }

    public static String containsSpam(String content) throws DataAccessException {
        if (!Environment.getBooleanValue("use-spam-filter")) {
            return null;
        }
        long start = System.currentTimeMillis();
        if (spamRegexPattern == null) {
            SpamFilter.initialize();
        }
        Matcher m = spamRegexPattern.matcher(content);
        String result = null;
        if (m.find()) {
            result = m.group(0);
        }
        long execution = System.currentTimeMillis() - start;
        logger.debug("Executed spam filter (" + (double)execution / 1000.0 + " s.)");
        return result;
    }

    private static void initialize() throws DataAccessException {
        File file = null;
        try {
            file = Utilities.getClassLoaderFile(SPAM_BLACKLIST_FILE);
        }
        catch (IOException e) {
            throw new DataAccessException("I/O exception while initlaizing spam blacklist", e);
        }
        String regex = "";
        String regexText = null;
        try {
            regexText = FileUtils.readFileToString((File)file, (String)"UTF-8").trim();
        }
        catch (IOException e) {
            throw new DataAccessException("I/O exception while initlaizing spam blacklist", e);
        }
        String[] tokens = regexText.split("\n");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (StringUtils.isBlank((String)token)) continue;
            if (i > 0) {
                regex = regex + "|";
            }
            regex = regex + token.trim();
        }
        try {
            spamRegexPattern = Pattern.compile(regex, 2);
        }
        catch (PatternSyntaxException e) {
            throw new DataAccessException("Failure while parsing spam regular expression list", e);
        }
        logger.info("Loading spam filter regular expression:" + regex);
    }

    public static void reload() throws DataAccessException {
        SpamFilter.initialize();
    }
}

