/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.HeaderFooter;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.extractor.XSSFEventBasedExcelExtractor;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.helpers.HeaderFooterHelper;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.MetadataExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFExcelExtractorDecorator
extends AbstractOOXMLExtractor {
    private final XSSFEventBasedExcelExtractor extractor;
    private final DataFormatter formatter;
    private final List<PackagePart> sheetParts = new ArrayList<PackagePart>();
    private final List<Boolean> sheetProtected = new ArrayList<Boolean>();
    private static HeaderFooterHelper hfHelper = new HeaderFooterHelper();

    public XSSFExcelExtractorDecorator(ParseContext context, XSSFEventBasedExcelExtractor extractor, Locale locale) {
        super(context, (POIXMLTextExtractor)extractor);
        this.extractor = extractor;
        extractor.setFormulasNotResults(false);
        extractor.setLocale(locale);
        this.formatter = locale == null ? new DataFormatter() : new DataFormatter(locale);
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        ReadOnlySharedStringsTable strings;
        XSSFReader.SheetIterator iter;
        StylesTable styles;
        OPCPackage container = this.extractor.getPackage();
        try {
            XSSFReader xssfReader = new XSSFReader(container);
            styles = xssfReader.getStylesTable();
            iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            strings = new ReadOnlySharedStringsTable(container);
        }
        catch (InvalidFormatException e) {
            throw new XmlException((Throwable)e);
        }
        catch (OpenXML4JException oe) {
            throw new XmlException((Throwable)oe);
        }
        while (iter.hasNext()) {
            InputStream stream = iter.next();
            this.sheetParts.add(iter.getSheetPart());
            SheetTextAsHTML sheetExtractor = new SheetTextAsHTML(xhtml, iter.getSheetComments());
            xhtml.startElement("div");
            xhtml.element("h1", iter.getSheetName());
            xhtml.startElement("table");
            xhtml.startElement("tbody");
            this.processSheet(sheetExtractor, styles, strings, stream);
            xhtml.endElement("tbody");
            xhtml.endElement("table");
            for (String header : sheetExtractor.headers) {
                this.extractHeaderFooter(header, xhtml);
            }
            for (String footer : sheetExtractor.footers) {
                this.extractHeaderFooter(footer, xhtml);
            }
            xhtml.endElement("div");
        }
    }

    private void extractHeaderFooter(String hf, XHTMLContentHandler xhtml) throws SAXException {
        String content = ExcelExtractor._extractHeaderFooter((HeaderFooter)new HeaderFooterFromString(hf));
        if (content.length() > 0) {
            xhtml.element("p", content);
        }
    }

    public void processSheet(XSSFSheetXMLHandler.SheetContentsHandler sheetContentsExtractor, StylesTable styles, ReadOnlySharedStringsTable strings, InputStream sheetInputStream) throws IOException, SAXException {
        InputSource sheetSource = new InputSource(sheetInputStream);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxFactory.newSAXParser();
            XMLReader sheetParser = saxParser.getXMLReader();
            XSSFSheetInterestingPartsCapturer handler = new XSSFSheetInterestingPartsCapturer((ContentHandler)new XSSFSheetXMLHandler(styles, strings, sheetContentsExtractor, this.formatter, false));
            sheetParser.setContentHandler(handler);
            sheetParser.parse(sheetSource);
            sheetInputStream.close();
            this.sheetProtected.add(handler.hasProtection);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() throws TikaException {
        ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
        for (PackagePart part : this.sheetParts) {
            parts.add(part);
            try {
                PackagePartName relName;
                for (PackageRelationship rel : part.getRelationshipsByType(XSSFRelation.DRAWINGS.getRelation())) {
                    if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                    relName = PackagingURIHelper.createPartName((URI)rel.getTargetURI());
                    parts.add(rel.getPackage().getPart(relName));
                }
                for (PackageRelationship rel : part.getRelationshipsByType(XSSFRelation.VML_DRAWINGS.getRelation())) {
                    if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                    relName = PackagingURIHelper.createPartName((URI)rel.getTargetURI());
                    parts.add(rel.getPackage().getPart(relName));
                }
            }
            catch (InvalidFormatException e) {
                throw new TikaException("Broken OOXML file", (Throwable)e);
            }
        }
        return parts;
    }

    @Override
    public MetadataExtractor getMetadataExtractor() {
        return new MetadataExtractor((POIXMLTextExtractor)this.extractor){

            public void extract(Metadata metadata) throws TikaException {
                super.extract(metadata);
                metadata.set("protected", "false");
                Iterator i$ = XSSFExcelExtractorDecorator.this.sheetProtected.iterator();
                while (i$.hasNext()) {
                    boolean prot = (Boolean)i$.next();
                    if (!prot) continue;
                    metadata.set("protected", "true");
                }
            }
        };
    }

    protected static class XSSFSheetInterestingPartsCapturer
    implements ContentHandler {
        private ContentHandler delegate;
        private boolean hasProtection = false;

        protected XSSFSheetInterestingPartsCapturer(ContentHandler delegate) {
            this.delegate = delegate;
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("sheetProtection".equals(qName)) {
                this.hasProtection = true;
            }
            this.delegate.startElement(uri, localName, qName, atts);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.delegate.characters(ch, start, length);
        }

        public void endDocument() throws SAXException {
            this.delegate.endDocument();
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.delegate.endElement(uri, localName, qName);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.delegate.endPrefixMapping(prefix);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.delegate.ignorableWhitespace(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.delegate.processingInstruction(target, data);
        }

        public void setDocumentLocator(Locator locator) {
            this.delegate.setDocumentLocator(locator);
        }

        public void skippedEntity(String name) throws SAXException {
            this.delegate.skippedEntity(name);
        }

        public void startDocument() throws SAXException {
            this.delegate.startDocument();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.delegate.startPrefixMapping(prefix, uri);
        }
    }

    protected static class HeaderFooterFromString
    implements HeaderFooter {
        private String text;

        protected HeaderFooterFromString(String text) {
            this.text = text;
        }

        public String getCenter() {
            return hfHelper.getCenterSection(this.text);
        }

        public String getLeft() {
            return hfHelper.getLeftSection(this.text);
        }

        public String getRight() {
            return hfHelper.getRightSection(this.text);
        }

        public void setCenter(String paramString) {
        }

        public void setLeft(String paramString) {
        }

        public void setRight(String paramString) {
        }
    }

    protected static class SheetTextAsHTML
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private XHTMLContentHandler xhtml;
        private CommentsTable comments;
        private List<String> headers;
        private List<String> footers;

        protected SheetTextAsHTML(XHTMLContentHandler xhtml, CommentsTable comments) {
            this.xhtml = xhtml;
            this.comments = comments;
            this.headers = new ArrayList<String>();
            this.footers = new ArrayList<String>();
        }

        public void startRow(int rowNum) {
            try {
                this.xhtml.startElement("tr");
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }

        public void endRow() {
            try {
                this.xhtml.endElement("tr");
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }

        public void cell(String cellRef, String formattedValue) {
            try {
                XSSFComment comment;
                this.xhtml.startElement("td");
                this.xhtml.characters(formattedValue);
                if (this.comments != null && (comment = this.comments.findCellComment(cellRef)) != null) {
                    this.xhtml.startElement("br");
                    this.xhtml.endElement("br");
                    this.xhtml.characters(comment.getAuthor());
                    this.xhtml.characters(": ");
                    this.xhtml.characters(comment.getString().getString());
                }
                this.xhtml.endElement("td");
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }

        public void headerFooter(String text, boolean isHeader, String tagName) {
            if (isHeader) {
                this.headers.add(text);
            } else {
                this.footers.add(text);
            }
        }
    }
}

