/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.forms;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.forms.FormElement;
import com.ecyrd.jspwiki.forms.FormInfo;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.util.FormUtil;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;

public class FormOutput
extends FormElement {
    public String execute(WikiContext ctx, Map params) throws PluginException {
        if (ctx.getHttpRequest() == null) {
            return "";
        }
        ResourceBundle rb = ctx.getBundle("plugin.PluginResources");
        String formName = (String)params.get("form");
        String submitForm = ctx.getHttpParameter("formname");
        String populator = (String)params.get("populate");
        if (!(submitForm != null && formName != null && formName.equals(submitForm) || populator != null && "handler".equals(populator))) {
            return "";
        }
        String handler = (String)params.get("handler");
        if (handler == null || handler.length() == 0) {
            Object[] args = new Object[]{"handler"};
            return "<p class=\"error\">" + MessageFormat.format(rb.getString("formoutput.missingargument"), args) + "</p>";
        }
        String sourcePage = ctx.getPage().getName();
        String submitServlet = ctx.getURL(WikiContext.VIEW, sourcePage);
        FormInfo info = this.getFormInfo(ctx);
        if (info == null) {
            info = new FormInfo();
            info.setName(formName);
        }
        info.setHandler(handler);
        info.setAction(submitServlet);
        Map handlerParams = FormUtil.requestToMap(ctx.getHttpRequest(), "nbf_");
        info.addSubmission(handlerParams);
        info.getSubmission().put("_body", params.get("_body"));
        String handlerOutput = null;
        String error = null;
        try {
            handlerOutput = ctx.getEngine().getPluginManager().execute(ctx, handler, info.getSubmission());
            info.setResult(handlerOutput);
            info.setStatus(1);
        }
        catch (PluginException pe) {
            error = "<p class=\"error\">" + pe.getMessage() + "</p>";
            info.setError(error);
            info.setStatus(-1);
        }
        this.storeFormInfo(ctx, info);
        if (error != null) {
            return error;
        }
        return handlerOutput != null ? handlerOutput : "";
    }
}

