/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.htmltowiki;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public final class PropertiesUtils {
    private static final String OTHER_WHITESPACE = "\t\r\n\f";
    private static final char[] HEXDIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private PropertiesUtils() {
    }

    public static String toSortedString(Properties properties) {
        TreeMap<Object, Object> treemap = new TreeMap<Object, Object>(properties);
        String string = "";
        for (Map.Entry<Object, Object> entry : treemap.entrySet()) {
            String key = (String)entry.getKey();
            String value = entry.getValue() == null ? "null" : entry.getValue().toString();
            string = string + PropertiesUtils.toLine(key, value) + '\n';
        }
        return string;
    }

    public static String toLine(String key, String value) {
        return PropertiesUtils.saveConvert(key, true) + '=' + PropertiesUtils.saveConvert(value, false);
    }

    public static String saveConvert(String string, boolean encodeWhiteSpace) {
        int i = string.length();
        StringBuffer stringbuffer = new StringBuffer(i * 2);
        block8: for (int i3 = 0; i3 < i; ++i3) {
            char c = string.charAt(i3);
            switch (c) {
                case ' ': {
                    if (i3 == 0 || encodeWhiteSpace) {
                        stringbuffer.append('\\');
                    }
                    stringbuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    stringbuffer.append('\\');
                    stringbuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    stringbuffer.append('\\');
                    stringbuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    stringbuffer.append('\\');
                    stringbuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    stringbuffer.append('\\');
                    stringbuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    stringbuffer.append('\\');
                    stringbuffer.append('f');
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringbuffer.append('\\');
                        stringbuffer.append('u');
                        stringbuffer.append(PropertiesUtils.toHex(c >> 12 & 0xF));
                        stringbuffer.append(PropertiesUtils.toHex(c >> 8 & 0xF));
                        stringbuffer.append(PropertiesUtils.toHex(c >> 4 & 0xF));
                        stringbuffer.append(PropertiesUtils.toHex(c & 0xF));
                        continue block8;
                    }
                    if (OTHER_WHITESPACE.indexOf(c) != -1) {
                        stringbuffer.append('\\');
                    }
                    stringbuffer.append(c);
                }
            }
        }
        return stringbuffer.toString();
    }

    private static char toHex(int i) {
        return HEXDIGIT[i & 0xF];
    }
}

