/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.events;

import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.IPumpable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BufferEvent
implements IPumpable,
Serializable {
    private EventSource source;

    public EventSource getSource() {
        return this.source;
    }

    public void setSource(EventSource source) {
        this.source = source;
    }

    @Override
    public void deflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeUTF(this.source.toString());
            this.extendDeflate(out);
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("Could not deflate event", e);
        }
    }

    public abstract void extendDeflate(DataOutput var1) throws GRS2RecordSerializationException;

    @Override
    public void inflate(DataInput in) throws GRS2RecordSerializationException {
        try {
            this.source = EventSource.valueOf(in.readUTF());
            this.extendInflate(in);
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("Could not inflate event", e);
        }
    }

    @Override
    public void inflate(DataInput in, boolean reset) throws GRS2RecordSerializationException {
        this.inflate(in);
    }

    public abstract void extendInflate(DataInput var1) throws GRS2RecordSerializationException;

    @Override
    public Element toXML(Document doc) throws GRS2RecordSerializationException, GRS2RecordDefinitionException, DOMException {
        Element element = doc.createElement("keyValueEvent");
        Element elm = null;
        elm = doc.createElement("source");
        elm.setTextContent(this.getSource().toString());
        element.appendChild(elm);
        this.extendToXML(doc, element);
        return element;
    }

    @Override
    public void fromXML(Element element) throws GRS2RecordSerializationException, GRS2RecordDefinitionException, DOMException {
        String source = element.getElementsByTagName("source").item(0).getTextContent();
        this.source = EventSource.valueOf(source);
        this.extendFromXML(element);
    }

    public abstract void extendToXML(Document var1, Element var2) throws GRS2RecordSerializationException;

    public abstract void extendFromXML(Element var1) throws GRS2RecordSerializationException;

    public static enum EventSource {
        Writer,
        Reader;

    }
}

