/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.http;

import gr.uoa.di.madgik.commons.server.http.IHTTPConnectionManagerEntry;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidArgumentException;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidOperationException;
import gr.uoa.di.madgik.grs.proxy.IProxy;
import gr.uoa.di.madgik.grs.proxy.http.HTTPReaderProxy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;

public class HTTPStoreReaderProxy
extends HTTPReaderProxy {
    private static Logger logger = Logger.getLogger(HTTPStoreReaderProxy.class.getName());
    private boolean storeContacted = false;

    @Override
    public void fromLocator(URI locator) throws GRS2ProxyInvalidArgumentException, GRS2ProxyInvalidOperationException {
        HttpURLConnection connection = null;
        BufferedReader in = null;
        try {
            if (this.storeContacted) {
                super.fromLocator(locator);
            } else {
                this.storeContacted = true;
                if (locator == null) {
                    throw new GRS2ProxyInvalidArgumentException("Locator cannot be null");
                }
                if (!HTTPStoreReaderProxy.isOfType(locator)) {
                    throw new GRS2ProxyInvalidArgumentException("Locator is not of appropriate type " + locator.toString());
                }
                if (locator.getQuery() == null) {
                    throw new GRS2ProxyInvalidArgumentException("Invalid query string in locator " + locator.toString());
                }
                String[] qs = locator.getQuery().trim().split("=");
                if (qs.length != 2) {
                    throw new GRS2ProxyInvalidArgumentException("Invalid query string in locator " + locator.toString());
                }
                if (qs[1].trim().length() == 0) {
                    throw new GRS2ProxyInvalidArgumentException("Invalid key in locator " + locator.toString());
                }
                String hostname = locator.getHost();
                int port = locator.getPort();
                String key = qs[1];
                connection = (HttpURLConnection)new URL("http://" + hostname + ":" + port).openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("key", key);
                connection.setRequestProperty("EntryName", IHTTPConnectionManagerEntry.NamedEntry.gRS2Store.name());
                in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String newLocatorStr = in.readLine();
                URI newLocator = new URI(newLocatorStr);
                this.fromLocator(newLocator);
            }
        }
        catch (URISyntaxException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new GRS2ProxyInvalidOperationException("Could not initialize new HTTP locator", e);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public IBuffer getBuffer() throws GRS2ProxyInvalidOperationException {
        if (!this.storeContacted) {
            throw new GRS2ProxyInvalidOperationException("Method not supported for this proxy type");
        }
        return super.getBuffer();
    }

    public static boolean isOfType(URI locator) {
        if (!locator.getScheme().equalsIgnoreCase(IProxy.ProxyType.HTTP.toString())) {
            return false;
        }
        return locator.getFragment().equalsIgnoreCase(IProxy.ProxyType.HTTPStore.toString());
    }
}

