/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.record.field;

import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorException;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorProtocolErrorException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GRS2RecordMediationException;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.IPumpable;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.mediation.MediatingInputStream;
import gr.uoa.di.madgik.grs.record.field.mediation.MediationFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Field
implements IPumpable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient Record record;
    private int definitionIndex = -1;
    private boolean remoteCopy = false;

    public void setDefinitionIndex(int index) {
        this.definitionIndex = index;
    }

    public int getDefinitionIndex() {
        return this.definitionIndex;
    }

    public void bind(Record record) {
        this.record = record;
    }

    public void prebind(Record record) {
        this.record = record;
    }

    public void setRemoteCopy(boolean remoteCopy) {
        this.remoteCopy = remoteCopy;
    }

    public boolean isRemoteCopy() {
        return this.remoteCopy;
    }

    public FieldDefinition getFieldDefinition() throws GRS2RecordDefinitionException {
        try {
            if (this.record == null) {
                throw new GRS2RecordDefinitionException("Field not properly bind to buffer");
            }
            if (this.definitionIndex < 0 || this.definitionIndex >= this.record.getDefinition().getDefinitionSize()) {
                throw new GRS2RecordDefinitionException("No definition found for index " + this.definitionIndex);
            }
            return this.record.getDefinition().getDefinition(this.definitionIndex);
        }
        catch (GRS2BufferException e) {
            throw new GRS2RecordDefinitionException("unable to retrieve field's definition", e);
        }
    }

    public IBuffer.TransportDirective resolveTransportDirective() throws GRS2RecordDefinitionException, GRS2BufferException {
        FieldDefinition def = this.getFieldDefinition();
        switch (def.getTransportDirective()) {
            case Full: 
            case Partial: {
                return def.getTransportDirective();
            }
            case Inherit: {
                return this.record.resolveTransportDirective();
            }
        }
        return IBuffer.TransportDirective.Full;
    }

    @Override
    public final void deflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeInt(this.definitionIndex);
            out.writeBoolean(this.remoteCopy);
            this.extendDeflate(out);
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("unable to marshal record", e);
        }
    }

    @Override
    public final Element toXML(Document doc) throws GRS2RecordSerializationException {
        Element element = doc.createElement("field");
        Element elm = null;
        elm = doc.createElement("definitionIndex");
        elm.setTextContent(String.valueOf(this.getDefinitionIndex()));
        element.appendChild(elm);
        elm = doc.createElement("remoteCopy");
        elm.setTextContent(String.valueOf(this.remoteCopy));
        element.appendChild(elm);
        this.extendToXML(doc, element);
        return element;
    }

    @Override
    public final void fromXML(Element element) throws GRS2RecordSerializationException {
        this.fromXML(element, false);
    }

    public final void fromXML(Element element, boolean reset) throws GRS2RecordSerializationException {
        Integer definitionIndex = Integer.valueOf(element.getElementsByTagName("definitionIndex").item(0).getTextContent());
        this.definitionIndex = definitionIndex;
        Boolean remoteCopy = Boolean.valueOf(element.getElementsByTagName("remoteCopy").item(0).getTextContent());
        this.remoteCopy = remoteCopy;
        if (reset) {
            this.remoteCopy = false;
        }
        this.extendFromXML(element, reset);
    }

    public final void send(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeInt(this.definitionIndex);
            out.writeBoolean(this.remoteCopy);
            this.extendSend(out, IBuffer.TransportOverride.Defined);
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("unable to marshal record", e);
        }
    }

    public final Element sendToXML(Document doc) throws GRS2RecordSerializationException {
        try {
            Element element = doc.createElement("field");
            Element elm = null;
            elm = doc.createElement("definitionIndex");
            elm.setTextContent(String.valueOf(this.getDefinitionIndex()));
            element.appendChild(elm);
            elm = doc.createElement("remoteCopy");
            elm.setTextContent(String.valueOf(this.remoteCopy));
            element.appendChild(elm);
            this.extendSendToXML(doc, element, IBuffer.TransportOverride.Defined);
            return element;
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to marshal record", e);
        }
    }

    public final void receiveFromXML(Element element) throws GRS2RecordSerializationException {
        try {
            Integer definitionIndex = Integer.parseInt(element.getElementsByTagName("definitionIndex").item(0).getTextContent());
            this.definitionIndex = definitionIndex;
            Boolean remoteCopy = Boolean.parseBoolean(element.getElementsByTagName("remoteCopy").item(0).getTextContent());
            this.remoteCopy = remoteCopy;
            this.extendReceiveFromXML(element, IBuffer.TransportOverride.Defined);
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to unmarshal record", e);
        }
    }

    public final void makeLocal() {
        this.extendMakeLocal();
        this.remoteCopy = false;
    }

    public abstract void extendDeflate(DataOutput var1) throws GRS2RecordSerializationException;

    public abstract void extendToXML(Document var1, Element var2) throws GRS2RecordSerializationException;

    public abstract void extendFromXML(Element var1, boolean var2) throws GRS2RecordSerializationException;

    public abstract void extendSend(DataOutput var1, IBuffer.TransportOverride var2) throws GRS2RecordSerializationException;

    protected abstract void extendMakeLocal();

    @Override
    public final void inflate(DataInput in) throws GRS2RecordSerializationException {
        this.inflate(in, false);
    }

    @Override
    public final void inflate(DataInput in, boolean reset) throws GRS2RecordSerializationException {
        try {
            this.definitionIndex = in.readInt();
            this.remoteCopy = in.readBoolean();
            if (reset) {
                this.remoteCopy = false;
            }
            this.extendInflate(in, reset);
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("unable to unmarshal record", e);
        }
    }

    public final void receive(DataInput in) throws GRS2RecordSerializationException {
        try {
            this.definitionIndex = in.readInt();
            this.remoteCopy = in.readBoolean();
            this.extendReceive(in, IBuffer.TransportOverride.Defined);
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("unable to unmarshal record", e);
        }
    }

    public abstract void extendInflate(DataInput var1, boolean var2) throws GRS2RecordSerializationException;

    public abstract void extendReceive(DataInput var1, IBuffer.TransportOverride var2) throws GRS2RecordSerializationException;

    public void dispose() {
        this.extendDispose();
        this.record = null;
        this.definitionIndex = -1;
    }

    public abstract void extendDispose();

    public abstract boolean isAvailable();

    public void makeAvailable() throws GRS2RecordDefinitionException, GRS2BufferException, GRS2ProxyMirrorException {
        this.makeAvailable(IBuffer.TransportOverride.Override);
    }

    public void makeAvailable(IBuffer.TransportOverride override) throws GRS2RecordDefinitionException, GRS2BufferException, GRS2ProxyMirrorException {
        if (this.isAvailable()) {
            return;
        }
        IBuffer.TransportDirective dir = this.resolveTransportDirective();
        if (dir == IBuffer.TransportDirective.Full) {
            return;
        }
        if (dir == IBuffer.TransportDirective.Inherit) {
            throw new GRS2ProxyMirrorProtocolErrorException("Unsupported transport directive after resolution");
        }
        this.record.requestPartial(override, this.getDefinitionIndex());
    }

    public abstract InputStream getInputStream() throws IOException;

    public MediatingInputStream getMediatingInputStream() throws IOException, GRS2RecordMediationException {
        return MediationFactory.getStream(this);
    }

    public abstract void extendSendToXML(Document var1, Element var2, IBuffer.TransportOverride var3) throws GRS2RecordSerializationException;

    public abstract void extendReceiveFromXML(Element var1, IBuffer.TransportOverride var2) throws GRS2RecordSerializationException;
}

