/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence;

import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;

public abstract class AbstractPersistenceManager
implements PersistenceManager {
    public NodeState createNew(NodeId id) {
        return new NodeState(id, null, null, 4, false);
    }

    public PropertyState createNew(PropertyId id) {
        return new PropertyState(id, 4, false);
    }

    public synchronized void store(ChangeLog changeLog) throws ItemStateException {
        for (ItemState state : changeLog.deletedStates()) {
            if (state.isNode()) {
                this.destroy((NodeState)state);
                continue;
            }
            this.destroy((PropertyState)state);
        }
        for (ItemState state : changeLog.addedStates()) {
            if (state.isNode()) {
                this.store((NodeState)state);
                continue;
            }
            this.store((PropertyState)state);
        }
        for (ItemState state : changeLog.modifiedStates()) {
            if (state.isNode()) {
                this.store((NodeState)state);
                continue;
            }
            this.store((PropertyState)state);
        }
        for (NodeReferences refs : changeLog.modifiedRefs()) {
            if (refs.hasReferences()) {
                this.store(refs);
                continue;
            }
            if (!this.existsReferencesTo(refs.getTargetId())) continue;
            this.destroy(refs);
        }
    }

    public void checkConsistency(String[] uuids, boolean recursive, boolean fix) {
    }

    protected abstract void store(NodeState var1) throws ItemStateException;

    protected abstract void store(PropertyState var1) throws ItemStateException;

    protected abstract void store(NodeReferences var1) throws ItemStateException;

    protected abstract void destroy(NodeState var1) throws ItemStateException;

    protected abstract void destroy(PropertyState var1) throws ItemStateException;

    protected abstract void destroy(NodeReferences var1) throws ItemStateException;
}

