/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OnWorkspaceInconsistency {
    private static final Logger log = LoggerFactory.getLogger(OnWorkspaceInconsistency.class);
    public static final OnWorkspaceInconsistency FAIL = new OnWorkspaceInconsistency("fail"){

        public void handleMissingChildNode(NoSuchItemStateException exception, QueryHandler handler, Path path, NodeState node, ChildNodeEntry child) throws RepositoryException, ItemStateException {
            DefaultNamePathResolver resolver = new DefaultNamePathResolver((NamespaceRegistry)handler.getContext().getNamespaceRegistry());
            log.error("Node {} ({}) has missing child '{}' ({})", new Object[]{resolver.getJCRPath(path), node.getNodeId(), resolver.getJCRName(child.getName()), child.getId()});
            throw exception;
        }
    };
    protected static final Map<String, OnWorkspaceInconsistency> INSTANCES = new HashMap<String, OnWorkspaceInconsistency>();
    private final String name;

    protected OnWorkspaceInconsistency(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static OnWorkspaceInconsistency fromString(String name) throws IllegalArgumentException {
        OnWorkspaceInconsistency handler = INSTANCES.get(name.toLowerCase());
        if (handler == null) {
            throw new IllegalArgumentException("Unknown name: " + name);
        }
        return handler;
    }

    public abstract void handleMissingChildNode(NoSuchItemStateException var1, QueryHandler var2, Path var3, NodeState var4, ChildNodeEntry var5) throws ItemStateException, RepositoryException;

    static {
        INSTANCES.put(OnWorkspaceInconsistency.FAIL.name, FAIL);
    }
}

