/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.ScoreNodeIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeIteratorImpl
implements NodeIterator {
    private static final Logger log = LoggerFactory.getLogger(NodeIteratorImpl.class);
    protected final ScoreNodeIterator scoreNodes;
    private final int selectorIndex;
    protected final ItemManager itemMgr;
    protected int invalid = 0;
    private NodeImpl next;
    private boolean initialized;

    NodeIteratorImpl(ItemManager itemMgr, ScoreNodeIterator scoreNodes, int selectorIndex) {
        this.itemMgr = itemMgr;
        this.scoreNodes = scoreNodes;
        this.selectorIndex = selectorIndex;
    }

    public Node nextNode() throws NoSuchElementException {
        this.initialize();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        NodeImpl n = this.next;
        this.fetchNext();
        return n;
    }

    public Object next() throws NoSuchElementException {
        this.initialize();
        return this.nextNode();
    }

    public void skip(long skipNum) throws NoSuchElementException {
        this.initialize();
        if (skipNum > 0L) {
            this.scoreNodes.skip(skipNum - 1L);
            this.fetchNext();
        }
    }

    public long getSize() {
        long size = this.scoreNodes.getSize();
        if (size == -1L) {
            return size;
        }
        return size - (long)this.invalid;
    }

    public long getPosition() {
        this.initialize();
        long position = this.scoreNodes.getPosition() - (long)this.invalid;
        if (this.next != null) {
            --position;
        }
        return position;
    }

    public boolean hasNext() {
        this.initialize();
        return this.next != null;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    protected void fetchNext() {
        this.next = null;
        while (this.next == null && this.scoreNodes.hasNext()) {
            ScoreNode[] sn = this.scoreNodes.nextScoreNodes();
            try {
                this.next = (NodeImpl)this.itemMgr.getItem(sn[this.selectorIndex].getNodeId());
            }
            catch (RepositoryException e) {
                log.warn("Exception retrieving Node with UUID: " + sn[this.selectorIndex].getNodeId() + ": " + e.toString());
                ++this.invalid;
            }
        }
    }

    protected void initialize() {
        if (!this.initialized) {
            this.fetchNext();
            this.initialized = true;
        }
    }
}

