/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.io.File;
import java.io.FileInputStream;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Properties;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJBossAccessManager
implements AccessManager {
    private static Logger log = LoggerFactory.getLogger(SimpleJBossAccessManager.class);
    protected boolean system;
    protected boolean anonymous;

    public void init(AMContext context) throws AccessDeniedException, Exception {
        this.init(context, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(AMContext context, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessMgr) throws AccessDeniedException, Exception {
        Properties rolemaps = new Properties();
        File rolemap = new File(context.getHomeDir(), "rolemapping.properties");
        log.info("Loading jbossgroup role mappings from {}", (Object)rolemap.getPath());
        FileInputStream rolefs = new FileInputStream(rolemap);
        try {
            rolemaps.load(rolefs);
        }
        finally {
            rolefs.close();
        }
        for (Principal principal : context.getSubject().getPrincipals()) {
            if (!(principal instanceof Group) || !principal.getName().equalsIgnoreCase("Roles")) continue;
            Group group = (Group)principal;
            Enumeration members = group.members();
            while (members.hasMoreElements()) {
                Principal member = (Principal)members.nextElement();
                String role = rolemaps.getProperty(member.getName());
                this.system = this.system || "full".equalsIgnoreCase(role);
                this.anonymous = this.anonymous || "read".equalsIgnoreCase(role);
            }
        }
    }

    public synchronized void close() {
    }

    public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, RepositoryException {
        if (!this.isGranted(id, permissions)) {
            throw new AccessDeniedException("Access denied");
        }
    }

    public void checkPermission(Path absPath, int permissions) throws AccessDeniedException, RepositoryException {
        if (!this.isGranted(absPath, permissions)) {
            throw new AccessDeniedException("Access denied");
        }
    }

    public boolean isGranted(ItemId id, int permissions) throws RepositoryException {
        return this.system || this.anonymous && (permissions & 6) == 0;
    }

    public boolean isGranted(Path absPath, int permissions) throws RepositoryException {
        return this.internalIsGranted(permissions);
    }

    public boolean isGranted(Path parentPath, Name childName, int permissions) throws RepositoryException {
        return this.internalIsGranted(permissions);
    }

    public boolean canRead(Path itemPath, ItemId itemId) throws RepositoryException {
        return true;
    }

    public boolean canAccess(String workspaceName) throws RepositoryException {
        return this.system || this.anonymous;
    }

    private boolean internalIsGranted(int permissions) {
        return this.system || this.anonymous && 1 == permissions;
    }
}

