/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.jackrabbit.core.CachingHierarchyManager;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ZombieHierarchyManager;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateListener;
import org.apache.jackrabbit.core.state.NodeStateMerger;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.state.StateChangeDispatcher;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionItemStateManager
implements UpdatableItemStateManager,
Dumpable,
NodeStateListener {
    private static Logger log = LoggerFactory.getLogger(SessionItemStateManager.class);
    private final UpdatableItemStateManager stateMgr;
    private CachingHierarchyManager hierMgr;
    private final Map<ItemId, ItemState> atticStore = new HashMap<ItemId, ItemState>();
    private final Map<ItemId, ItemState> transientStore = new HashMap<ItemId, ItemState>();
    private AtticItemStateManager attic;
    private final NodeTypeRegistry ntReg;
    private final transient StateChangeDispatcher dispatcher = new StateChangeDispatcher();

    public SessionItemStateManager(NodeId rootNodeId, LocalItemStateManager stateMgr, NodeTypeRegistry ntReg) {
        this.stateMgr = stateMgr;
        this.ntReg = ntReg;
        this.hierMgr = new CachingHierarchyManager(rootNodeId, this);
        this.addListener(this.hierMgr);
    }

    public static SessionItemStateManager createInstance(NodeId rootNodeId, LocalItemStateManager stateMgr, NodeTypeRegistry ntReg) {
        SessionItemStateManager mgr = new SessionItemStateManager(rootNodeId, stateMgr, ntReg);
        stateMgr.addListener(mgr);
        return mgr;
    }

    public HierarchyManager getHierarchyMgr() {
        return this.hierMgr;
    }

    public HierarchyManager getAtticAwareHierarchyMgr() {
        return new ZombieHierarchyManager(this.hierMgr, this, this.getAttic());
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("SessionItemStateManager (" + this + ")");
        ps.println();
        ps.print("[transient] ");
        if (this.transientStore instanceof Dumpable) {
            ((Dumpable)((Object)this.transientStore)).dump(ps);
        } else {
            ps.println(this.transientStore.toString());
        }
        ps.println();
        ps.print("[attic]     ");
        if (this.atticStore instanceof Dumpable) {
            ((Dumpable)((Object)this.atticStore)).dump(ps);
        } else {
            ps.println(this.atticStore.toString());
        }
        ps.println();
    }

    @Override
    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        if (this.atticStore.containsKey(id)) {
            return this.getTransientItemState(id);
        }
        if (this.transientStore.containsKey(id)) {
            return this.getTransientItemState(id);
        }
        return this.stateMgr.getItemState(id);
    }

    @Override
    public boolean hasItemState(ItemId id) {
        if (this.atticStore.containsKey(id)) {
            return this.transientStore.containsKey(id);
        }
        if (this.transientStore.containsKey(id)) {
            return true;
        }
        return this.stateMgr.hasItemState(id);
    }

    @Override
    public NodeReferences getNodeReferences(NodeId id) throws NoSuchItemStateException, ItemStateException {
        return this.stateMgr.getNodeReferences(id);
    }

    @Override
    public boolean hasNodeReferences(NodeId id) {
        return this.stateMgr.hasNodeReferences(id);
    }

    @Override
    public void edit() throws IllegalStateException {
        this.stateMgr.edit();
    }

    @Override
    public boolean inEditMode() {
        return this.stateMgr.inEditMode();
    }

    @Override
    public NodeState createNew(NodeId id, Name nodeTypeName, NodeId parentId) throws IllegalStateException {
        return this.stateMgr.createNew(id, nodeTypeName, parentId);
    }

    public NodeState createNew(NodeState transientState) throws IllegalStateException {
        NodeState persistentState = this.createNew(transientState.getNodeId(), transientState.getNodeTypeName(), transientState.getParentId());
        transientState.connect(persistentState);
        return persistentState;
    }

    @Override
    public PropertyState createNew(Name propName, NodeId parentId) throws IllegalStateException {
        return this.stateMgr.createNew(propName, parentId);
    }

    public PropertyState createNew(PropertyState transientState) throws IllegalStateException {
        PropertyState persistentState = this.createNew(transientState.getName(), transientState.getParentId());
        transientState.connect(persistentState);
        return persistentState;
    }

    @Override
    public void store(ItemState state) throws IllegalStateException {
        this.stateMgr.store(state);
    }

    @Override
    public void destroy(ItemState state) throws IllegalStateException {
        this.stateMgr.destroy(state);
    }

    @Override
    public void cancel() throws IllegalStateException {
        this.stateMgr.cancel();
    }

    @Override
    public void update() throws ReferentialIntegrityException, StaleItemStateException, ItemStateException, IllegalStateException {
        this.stateMgr.update();
    }

    @Override
    public void dispose() {
        this.removeListener(this.hierMgr);
        this.disposeAllTransientItemStates();
        this.stateMgr.dispose();
    }

    public ItemState getTransientItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemState state = this.transientStore.get(id);
        if (state != null) {
            return state;
        }
        throw new NoSuchItemStateException(id.toString());
    }

    public boolean hasTransientItemState(ItemId id) {
        return this.transientStore.containsKey(id);
    }

    public boolean hasTransientItemStateInAttic(ItemId id) {
        return this.atticStore.containsKey(id);
    }

    public boolean hasAnyTransientItemStates() {
        return !this.transientStore.isEmpty();
    }

    public Iterator<ItemState> getDescendantTransientItemStates(NodeId parentId) throws InvalidItemStateException, RepositoryException {
        if (this.transientStore.isEmpty()) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        List[] la = new List[10];
        try {
            HierarchyManager atticAware = this.getAtticAwareHierarchyMgr();
            for (ItemState state : this.transientStore.values()) {
                ArrayList<ItemState> list;
                int depth;
                try {
                    depth = atticAware.getShareRelativeDepth(parentId, state.getId());
                }
                catch (ItemNotFoundException infe) {
                    String msg = state.getId() + ": the item seems to have been removed externally.";
                    log.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
                if (depth < 1) continue;
                if (depth > la.length) {
                    List[] old = la;
                    la = new List[depth + 10];
                    System.arraycopy(old, 0, la, 0, old.length);
                }
                if ((list = la[depth - 1]) == null) {
                    la[depth - 1] = list = new ArrayList<ItemState>();
                }
                list.add(state);
            }
        }
        catch (RepositoryException re) {
            log.warn("inconsistent hierarchy state", (Throwable)re);
        }
        IteratorChain resultIter = new IteratorChain();
        for (int i = la.length - 1; i >= 0; --i) {
            List list = la[i];
            if (list == null) continue;
            resultIter.addIterator(list.iterator());
        }
        if (resultIter.getIterators().isEmpty()) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        return resultIter;
    }

    public Iterator<ItemState> getDescendantTransientItemStatesInAttic(NodeId parentId) {
        if (this.atticStore.isEmpty()) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        ZombieHierarchyManager zombieHierMgr = new ZombieHierarchyManager(this.hierMgr, this, this.getAttic());
        List[] la = new List[10];
        try {
            for (ItemState state : this.atticStore.values()) {
                ArrayList<ItemState> list;
                int depth = zombieHierMgr.getShareRelativeDepth(parentId, state.getId());
                if (depth < 1) continue;
                if (depth > la.length) {
                    List[] old = la;
                    la = new List[depth + 10];
                    System.arraycopy(old, 0, la, 0, old.length);
                }
                if ((list = la[depth - 1]) == null) {
                    la[depth - 1] = list = new ArrayList<ItemState>();
                }
                list.add(state);
            }
        }
        catch (RepositoryException re) {
            log.warn("inconsistent hierarchy state", (Throwable)re);
        }
        IteratorChain resultIter = new IteratorChain();
        for (int i = la.length - 1; i >= 0; --i) {
            List list = la[i];
            if (list == null) continue;
            resultIter.addIterator(list.iterator());
        }
        if (resultIter.getIterators().isEmpty()) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        return resultIter;
    }

    public NodeId getIdOfRootTransientNodeState() throws RepositoryException {
        if (this.transientStore.isEmpty()) {
            return null;
        }
        if (this.transientStore.containsKey(this.hierMgr.getRootNodeId())) {
            return this.hierMgr.getRootNodeId();
        }
        LinkedList<NodeId> candidateIds = new LinkedList<NodeId>();
        try {
            ItemState state2;
            HierarchyManager hierMgr = this.getHierarchyMgr();
            for (ItemState state2 : this.transientStore.values()) {
                if (state2.getStatus() != 2 && state2.getStatus() != 6) continue;
                NodeId nodeId = state2.isNode() ? (NodeId)state2.getId() : state2.getParentId();
                boolean skip = false;
                for (NodeId id : candidateIds) {
                    if (nodeId.equals(id) || hierMgr.isAncestor(id, nodeId)) {
                        skip = true;
                        break;
                    }
                    if (!hierMgr.isAncestor(nodeId, id)) continue;
                    candidateIds.remove(id);
                }
                if (skip) continue;
                candidateIds.add(nodeId);
            }
            if (candidateIds.size() == 1) {
                return (NodeId)candidateIds.iterator().next();
            }
            NodeId candidateId = null;
            for (NodeId id : candidateIds) {
                if (candidateId == null) {
                    candidateId = id;
                    continue;
                }
                if (hierMgr.getDepth(id) >= hierMgr.getDepth(candidateId)) continue;
                candidateId = id;
            }
            state2 = (NodeState)this.getItemState(candidateId);
            NodeId parentId = ((NodeState)state2).getParentId();
            boolean continueWithParent = false;
            while (parentId != null) {
                for (NodeId id : candidateIds) {
                    if (hierMgr.getRelativeDepth(parentId, id) != -1) continue;
                    continueWithParent = true;
                    break;
                }
                if (!continueWithParent) break;
                state2 = (NodeState)this.getItemState(candidateId);
                parentId = ((NodeState)state2).getParentId();
                continueWithParent = false;
            }
            return parentId;
        }
        catch (ItemStateException e) {
            throw new RepositoryException("failed to determine common root of transient changes", (Throwable)e);
        }
    }

    public boolean isItemStateInAttic(ItemId id) {
        return this.atticStore.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState createTransientNodeState(NodeId id, Name nodeTypeName, NodeId parentId, int initialStatus) throws ItemStateException {
        Map<ItemId, ItemState> map = this.transientStore;
        synchronized (map) {
            if (this.transientStore.containsKey(id)) {
                String msg = "there's already a node state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            NodeState state = new NodeState(id, nodeTypeName, parentId, initialStatus, true);
            this.transientStore.put(state.getId(), state);
            state.setContainer(this);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState createTransientNodeState(NodeState overlayedState, int initialStatus) throws ItemStateException {
        NodeId id = overlayedState.getNodeId();
        Map<ItemId, ItemState> map = this.transientStore;
        synchronized (map) {
            if (this.transientStore.containsKey(id)) {
                String msg = "there's already a node state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            NodeState state = new NodeState(overlayedState, initialStatus, true);
            this.transientStore.put(id, state);
            state.setContainer(this);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyState createTransientPropertyState(NodeId parentId, Name propName, int initialStatus) throws ItemStateException {
        PropertyId id = new PropertyId(parentId, propName);
        Map<ItemId, ItemState> map = this.transientStore;
        synchronized (map) {
            if (this.transientStore.containsKey(id)) {
                String msg = "there's already a property state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            PropertyState state = new PropertyState(id, initialStatus, true);
            this.transientStore.put(id, state);
            state.setContainer(this);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyState createTransientPropertyState(PropertyState overlayedState, int initialStatus) throws ItemStateException {
        PropertyId id = overlayedState.getPropertyId();
        Map<ItemId, ItemState> map = this.transientStore;
        synchronized (map) {
            if (this.transientStore.containsKey(id)) {
                String msg = "there's already a property state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            PropertyState state = new PropertyState(overlayedState, initialStatus, true);
            this.transientStore.put(id, state);
            state.setContainer(this);
            return state;
        }
    }

    public void disconnectTransientItemState(ItemState state) {
        state.disconnect();
    }

    public void disposeTransientItemState(ItemState state) {
        state.discard();
        this.transientStore.remove(state.getId());
        state.onDisposed();
    }

    public void moveTransientItemStateToAttic(ItemState state) {
        this.transientStore.remove(state.getId());
        this.atticStore.put(state.getId(), state);
    }

    public void disposeTransientItemStateInAttic(ItemState state) {
        state.discard();
        this.atticStore.remove(state.getId());
        state.onDisposed();
    }

    public void disposeAllTransientItemStates() {
        ArrayList<ItemState> tmp = new ArrayList<ItemState>(this.transientStore.values());
        for (ItemState state : tmp) {
            this.disposeTransientItemState(state);
        }
        tmp = new ArrayList<ItemState>(this.atticStore.values());
        for (ItemState state : tmp) {
            this.disposeTransientItemStateInAttic(state);
        }
    }

    public void addListener(ItemStateListener listener) {
        this.dispatcher.addListener(listener);
    }

    public void removeListener(ItemStateListener listener) {
        this.dispatcher.removeListener(listener);
    }

    public ItemStateManager getAttic() {
        if (this.attic == null) {
            this.attic = new AtticItemStateManager();
        }
        return this.attic;
    }

    @Override
    public void stateCreated(ItemState created) {
        ItemState transientState;
        ItemState visibleState = created;
        if (created.getContainer() != this && (transientState = this.transientStore.get(created.getId())) != null) {
            if (transientState.hasOverlayedState()) {
                transientState.pull();
                transientState.setStatus(1);
            } else {
                try {
                    ItemState local = this.stateMgr.getItemState(created.getId());
                    transientState.connect(local);
                    transientState.setModCount(local.getModCount());
                    transientState.setStatus(2);
                }
                catch (ItemStateException e) {
                    transientState.setStatus(5);
                }
            }
            visibleState = transientState;
        }
        this.dispatcher.notifyStateCreated(visibleState);
    }

    @Override
    public void stateModified(ItemState modified) {
        ItemState visibleState = modified;
        if (modified.getContainer() != this) {
            ItemState transientState = this.transientStore.get(modified.getId());
            if (transientState != null) {
                NodeStateMerger.MergeContext context;
                if (transientState.isNode() && !transientState.isStale() && NodeStateMerger.merge((NodeState)transientState, context = new NodeStateMerger.MergeContext(){

                    public boolean isAdded(ItemId id) {
                        ItemState is = (ItemState)SessionItemStateManager.this.transientStore.get(id);
                        return is != null && is.getStatus() == 4;
                    }

                    public boolean isDeleted(ItemId id) {
                        return SessionItemStateManager.this.atticStore.containsKey(id);
                    }

                    public boolean isModified(ItemId id) {
                        ItemState is = (ItemState)SessionItemStateManager.this.transientStore.get(id);
                        return is != null && is.getStatus() == 2;
                    }

                    public boolean allowsSameNameSiblings(NodeId id) {
                        try {
                            NodeState ns = (NodeState)SessionItemStateManager.this.getItemState(id);
                            NodeState parent = (NodeState)SessionItemStateManager.this.getItemState(ns.getParentId());
                            Name name = parent.getChildNodeEntry(id).getName();
                            EffectiveNodeType ent = SessionItemStateManager.this.ntReg.getEffectiveNodeType(parent.getNodeTypeName(), parent.getMixinTypeNames());
                            QNodeDefinition def = ent.getApplicableChildNodeDef(name, ns.getNodeTypeName(), SessionItemStateManager.this.ntReg);
                            return def != null ? def.allowsSameNameSiblings() : false;
                        }
                        catch (Exception e) {
                            log.warn("Unable to get node definition", (Throwable)e);
                            return false;
                        }
                    }
                })) {
                    return;
                }
                transientState.setStatus(5);
                visibleState = transientState;
            }
            if ((transientState = this.atticStore.get(modified.getId())) != null) {
                transientState.setStatus(5);
                visibleState = transientState;
            }
        }
        this.dispatcher.notifyStateModified(visibleState);
    }

    @Override
    public void stateDestroyed(ItemState destroyed) {
        ItemState visibleState = destroyed;
        if (destroyed.getContainer() != this) {
            ItemState transientState = this.transientStore.get(destroyed.getId());
            if (transientState != null) {
                transientState.setStatus(6);
                visibleState = transientState;
            } else {
                transientState = this.atticStore.get(destroyed.getId());
                if (transientState != null) {
                    this.atticStore.remove(destroyed.getId());
                    transientState.onDisposed();
                }
            }
        }
        this.dispatcher.notifyStateDestroyed(visibleState);
    }

    @Override
    public void stateDiscarded(ItemState discarded) {
        ItemState transientState;
        ItemState visibleState = discarded;
        if (discarded.getContainer() != this && (transientState = this.transientStore.get(discarded.getId())) != null) {
            transientState.setStatus(0);
            visibleState = transientState;
        }
        this.dispatcher.notifyStateDiscarded(visibleState);
    }

    @Override
    public void nodeAdded(NodeState state, Name name, int index, NodeId id) {
        if (state.getContainer() == this || !this.transientStore.containsKey(state.getId())) {
            this.dispatcher.notifyNodeAdded(state, name, index, id);
        }
    }

    @Override
    public void nodesReplaced(NodeState state) {
        if (state.getContainer() == this || !this.transientStore.containsKey(state.getId())) {
            this.dispatcher.notifyNodesReplaced(state);
        }
    }

    @Override
    public void nodeModified(NodeState state) {
        if (state.getContainer() == this || !this.transientStore.containsKey(state.getId())) {
            this.dispatcher.notifyNodeModified(state);
        }
    }

    @Override
    public void nodeRemoved(NodeState state, Name name, int index, NodeId id) {
        if (state.getContainer() == this || !this.transientStore.containsKey(state.getId())) {
            this.dispatcher.notifyNodeRemoved(state, name, index, id);
        }
    }

    private class AtticItemStateManager
    implements ItemStateManager {
        private AtticItemStateManager() {
        }

        public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
            ItemState state = (ItemState)SessionItemStateManager.this.atticStore.get(id);
            if (state != null) {
                return state;
            }
            throw new NoSuchItemStateException(id.toString());
        }

        public boolean hasItemState(ItemId id) {
            return SessionItemStateManager.this.atticStore.containsKey(id);
        }

        public NodeReferences getNodeReferences(NodeId id) throws NoSuchItemStateException, ItemStateException {
            throw new ItemStateException("getNodeReferences() not implemented");
        }

        public boolean hasNodeReferences(NodeId id) {
            return false;
        }
    }
}

