/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteCollections;
import it.unimi.dsi.fastutil.bytes.ByteSets;
import it.unimi.dsi.fastutil.chars.AbstractChar2ByteMap;
import it.unimi.dsi.fastutil.chars.Char2ByteMap;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.chars.CharSets;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.io.Serializable;
import java.util.Map;

public class Char2ByteMaps {
    public static final EmptyMap EMPTY_MAP = new EmptyMap();

    private Char2ByteMaps() {
    }

    public static Char2ByteMap singleton(char key, byte value) {
        return new Singleton(key, value);
    }

    public static Char2ByteMap singleton(Character key, Byte value) {
        return new Singleton(key.charValue(), value);
    }

    public static Char2ByteMap synchronize(Char2ByteMap m) {
        return new SynchronizedMap(m);
    }

    public static Char2ByteMap synchronize(Char2ByteMap m, Object sync) {
        return new SynchronizedMap(m, sync);
    }

    public static Char2ByteMap unmodifiable(Char2ByteMap m) {
        return new UnmodifiableMap(m);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnmodifiableMap
    extends AbstractChar2ByteMap
    implements Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Char2ByteMap map;
        protected volatile transient ObjectSet<Map.Entry<Character, Byte>> entries;
        protected volatile transient CharSet keys;
        protected volatile transient ByteCollection values;

        protected UnmodifiableMap(Char2ByteMap m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean containsKey(char k) {
            return this.map.containsKey(k);
        }

        @Override
        public boolean containsValue(byte v) {
            return this.map.containsValue(v);
        }

        @Override
        public byte defaultReturnValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void defaultReturnValue(byte defRetValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte put(char k, byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends Character, ? extends Byte> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSet<Map.Entry<Character, Byte>> entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.unmodifiable(this.map.entrySet());
            }
            return this.entries;
        }

        @Override
        public CharSet keySet() {
            if (this.keys == null) {
                this.keys = CharSets.unmodifiable(this.map.keySet());
            }
            return this.keys;
        }

        @Override
        public ByteCollection values() {
            if (this.values == null) {
                return ByteCollections.unmodifiable(this.map.values());
            }
            return this.values;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this.map.toString();
        }

        @Override
        public Byte put(Character k, Byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte remove(char k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte get(char k) {
            return this.map.get(k);
        }

        @Override
        public boolean containsKey(Object ok) {
            return this.map.containsKey(ok);
        }

        @Override
        public boolean containsValue(Object ov) {
            return this.map.containsValue(ov);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SynchronizedMap
    extends AbstractChar2ByteMap
    implements Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Char2ByteMap map;
        protected final Object sync;
        protected volatile transient ObjectSet<Map.Entry<Character, Byte>> entries;
        protected volatile transient CharSet keys;
        protected volatile transient ByteCollection values;

        protected SynchronizedMap(Char2ByteMap m, Object sync) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
            this.sync = sync;
        }

        protected SynchronizedMap(Char2ByteMap m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(char k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsKey(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(byte v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsValue(v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte defaultReturnValue() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.defaultReturnValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void defaultReturnValue(byte defRetValue) {
            Object object = this.sync;
            synchronized (object) {
                this.map.defaultReturnValue(defRetValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte put(char k, byte v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends Character, ? extends Byte> m) {
            Object object = this.sync;
            synchronized (object) {
                this.map.putAll(m);
            }
        }

        @Override
        public ObjectSet<Map.Entry<Character, Byte>> entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.synchronize(this.map.entrySet(), this.sync);
            }
            return this.entries;
        }

        @Override
        public CharSet keySet() {
            if (this.keys == null) {
                this.keys = CharSets.synchronize(this.map.keySet(), this.sync);
            }
            return this.keys;
        }

        @Override
        public ByteCollection values() {
            if (this.values == null) {
                return ByteCollections.synchronize(this.map.values(), this.sync);
            }
            return this.values;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.map.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Byte put(Character k, Byte v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte remove(char k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.remove(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte get(char k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.get(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsKey(ok);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object ov) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsValue(ov);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Singleton
    extends AbstractChar2ByteMap
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final char key;
        protected final byte value;
        protected volatile transient ObjectSet<Map.Entry<Character, Byte>> entries;
        protected volatile transient CharSet keys;
        protected volatile transient ByteCollection values;

        protected Singleton(char key, byte value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean containsKey(char k) {
            return this.key == k;
        }

        @Override
        public boolean containsValue(byte v) {
            return this.value == v;
        }

        @Override
        public void putAll(Map<? extends Character, ? extends Byte> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSet<Map.Entry<Character, Byte>> entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.singleton(new SingletonEntry());
            }
            return this.entries;
        }

        @Override
        public CharSet keySet() {
            if (this.keys == null) {
                this.keys = CharSets.singleton(this.key);
            }
            return this.keys;
        }

        @Override
        public ByteCollection values() {
            if (this.values == null) {
                this.values = ByteSets.singleton(this.value);
            }
            return this.values;
        }

        @Override
        public byte get(char k) {
            if (this.key == k) {
                return this.value;
            }
            return this.defRetValue;
        }

        @Override
        public int size() {
            return 1;
        }

        public Object clone() {
            return this;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class SingletonEntry
        implements Char2ByteMap.Entry,
        Map.Entry<Character, Byte> {
            protected SingletonEntry() {
            }

            @Override
            public Character getKey() {
                return Character.valueOf(Singleton.this.key);
            }

            @Override
            public Byte getValue() {
                return Singleton.this.value;
            }

            @Override
            public char getCharKey() {
                return Singleton.this.key;
            }

            @Override
            public byte getByteValue() {
                return Singleton.this.value;
            }

            @Override
            public byte setValue(byte value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Byte setValue(Byte value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return Singleton.this.key == ((Character)e.getKey()).charValue() && Singleton.this.value == (Byte)e.getValue();
            }

            @Override
            public int hashCode() {
                return Singleton.this.key ^ Singleton.this.value;
            }

            public String toString() {
                return Singleton.this.key + "->" + Singleton.this.value;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EmptyMap
    extends AbstractChar2ByteMap
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptyMap() {
        }

        @Override
        public byte put(char k, byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte get(char k) {
            return 0;
        }

        @Override
        public boolean containsKey(char k) {
            return false;
        }

        @Override
        public boolean containsValue(byte v) {
            return false;
        }

        @Override
        public byte defaultReturnValue() {
            return 0;
        }

        @Override
        public void defaultReturnValue(byte defRetValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends Character, ? extends Byte> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSet<Map.Entry<Character, Byte>> entrySet() {
            return ObjectSets.EMPTY_SET;
        }

        @Override
        public CharSet keySet() {
            return CharSets.EMPTY_SET;
        }

        @Override
        public ByteCollection values() {
            return ByteSets.EMPTY_SET;
        }

        @Override
        public Byte put(Character k, Byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Byte get(Object k) {
            return null;
        }

        @Override
        public boolean containsKey(Object ok) {
            return false;
        }

        @Override
        public boolean containsValue(Object ov) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void clear() {
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }

        public Object clone() {
            return EMPTY_MAP;
        }
    }
}

