/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.DoubleArrayIndirectPriorityQueue;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleComparators;
import it.unimi.dsi.fastutil.doubles.DoubleIndirectDoublePriorityQueue;

public class DoubleArrayIndirectDoublePriorityQueue
extends DoubleArrayIndirectPriorityQueue
implements DoubleIndirectDoublePriorityQueue {
    protected DoubleComparator secondaryComparator;

    public DoubleArrayIndirectDoublePriorityQueue(double[] refArray, int capacity, DoubleComparator c, DoubleComparator d) {
        super(refArray, capacity, c);
        this.secondaryComparator = d;
    }

    public DoubleArrayIndirectDoublePriorityQueue(double[] refArray, int capacity, DoubleComparator c) {
        super(refArray, capacity, c == null ? DoubleComparators.OPPOSITE_COMPARATOR : DoubleComparators.oppositeComparator(c));
    }

    public DoubleArrayIndirectDoublePriorityQueue(double[] refArray, int capacity) {
        this(refArray, capacity, null);
    }

    public DoubleArrayIndirectDoublePriorityQueue(double[] refArray, DoubleComparator c, DoubleComparator d) {
        this(refArray, refArray.length, c, d);
    }

    public DoubleArrayIndirectDoublePriorityQueue(double[] refArray, DoubleComparator c) {
        this(refArray, refArray.length, c);
    }

    public DoubleArrayIndirectDoublePriorityQueue(double[] refArray) {
        this(refArray, refArray.length, null);
    }

    public DoubleArrayIndirectDoublePriorityQueue(double[] refArray, int[] a, int size, DoubleComparator c, DoubleComparator d) {
        this(refArray, 0, c, d);
        this.array = a;
        this.size = size;
    }

    public DoubleArrayIndirectDoublePriorityQueue(double[] refArray, int[] a, DoubleComparator c, DoubleComparator d) {
        this(refArray, a, a.length, c, d);
    }

    public DoubleArrayIndirectDoublePriorityQueue(double[] refArray, int[] a, int size, DoubleComparator c) {
        this(refArray, 0, c);
        this.array = a;
        this.size = size;
    }

    public DoubleArrayIndirectDoublePriorityQueue(double[] refArray, int[] a, DoubleComparator c) {
        this(refArray, a, a.length, c);
    }

    public DoubleArrayIndirectDoublePriorityQueue(double[] refArray, int[] a, int size) {
        this(refArray, a, size, null);
    }

    public DoubleArrayIndirectDoublePriorityQueue(double[] refArray, int[] a) {
        this(refArray, a, a.length);
    }

    private int findSecondaryFirst() {
        int i = this.size;
        int firstIndex = --i;
        double first = this.refArray[this.array[firstIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (!(this.refArray[this.array[i]] < first)) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(this.refArray[this.array[i]], first) >= 0) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        }
        return firstIndex;
    }

    private int findSecondaryLast() {
        int i = this.size;
        int lastIndex = --i;
        double last = this.refArray[this.array[lastIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (!(last < this.refArray[this.array[i]])) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(last, this.refArray[this.array[i]]) >= 0) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        }
        return lastIndex;
    }

    public int secondaryFirst() {
        return this.array[this.findSecondaryFirst()];
    }

    public int secondaryLast() {
        return this.array[this.findSecondaryLast()];
    }

    public void changed(int i) {
    }

    public DoubleComparator secondaryComparator() {
        return this.secondaryComparator;
    }
}

