/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.util.Arrays;
import java.util.Iterator;
import jodd.db.oom.DbOomQuery;
import jodd.db.oom.mapper.ResultSetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbListIterator<T>
implements Iterator<T> {
    protected final DbOomQuery query;
    protected final boolean entityAwareMode;
    protected final ResultSetMapper resultSetMapper;
    protected final Class[] types;
    protected final boolean closeOnEnd;
    protected T previousElement;
    protected T newElement;
    protected int count;
    protected boolean last;

    DbListIterator(DbOomQuery query, Class[] types, boolean closeOnEnd) {
        this.query = query;
        this.resultSetMapper = query.executeAndBuildResultSetMapper();
        this.entityAwareMode = query.entityAwareMode;
        this.types = types == null ? this.resultSetMapper.resolveTables() : types;
        this.closeOnEnd = closeOnEnd;
    }

    DbListIterator(DbOomQuery query, Class[] types, ResultSetMapper resultSetMapper, boolean closeOnEnd) {
        this.query = query;
        this.resultSetMapper = resultSetMapper;
        this.entityAwareMode = query.entityAwareMode;
        this.types = types == null ? resultSetMapper.resolveTables() : types;
        this.closeOnEnd = closeOnEnd;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.last) {
            if (this.closeOnEnd) {
                this.query.close();
            } else {
                this.query.closeResultSet(this.resultSetMapper.getResultSet());
            }
            return false;
        }
        while (true) {
            boolean equals;
            if (!this.resultSetMapper.next()) {
                this.last = true;
                return this.entityAwareMode;
            }
            Object[] objects = this.resultSetMapper.parseObjects(this.types);
            Object row = this.query.resolveRowResults(objects);
            this.newElement = row;
            if (!this.entityAwareMode) break;
            if (this.count == 0 && this.previousElement == null) {
                this.previousElement = this.newElement;
                continue;
            }
            if (this.previousElement == null || this.newElement == null || !(equals = this.newElement.getClass().isArray() ? Arrays.equals((Object[])this.previousElement, (Object[])this.newElement) : this.previousElement.equals(this.newElement))) break;
        }
        return true;
    }

    @Override
    public T next() {
        if (!this.entityAwareMode) {
            return this.newElement;
        }
        ++this.count;
        T result = this.previousElement;
        this.previousElement = this.newElement;
        return result;
    }
}

