/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import jodd.introspector.ClassDescriptor;
import jodd.util.ReflectUtil;

public class MethodDescriptor {
    protected final ClassDescriptor classDescriptor;
    protected final Method method;
    protected final Type returnType;
    protected final Class rawReturnType;
    protected final Class rawReturnComponentType;
    protected final Class rawReturnKeyComponentType;
    protected final Class[] rawParameterTypes;

    public MethodDescriptor(ClassDescriptor classDescriptor, Method method) {
        this.classDescriptor = classDescriptor;
        this.method = method;
        this.returnType = method.getGenericReturnType();
        this.rawReturnType = ReflectUtil.getRawType(this.returnType, classDescriptor.getType());
        this.rawReturnComponentType = ReflectUtil.getComponentType(this.returnType, classDescriptor.getType());
        this.rawReturnKeyComponentType = ReflectUtil.getComponentType(this.returnType, classDescriptor.getType(), 0);
        Type[] params = method.getGenericParameterTypes();
        this.rawParameterTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Type type = params[i];
            this.rawParameterTypes[i] = ReflectUtil.getRawType(type, classDescriptor.getType());
        }
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class getRawReturnType() {
        return this.rawReturnType;
    }

    public Class getRawReturnComponentType() {
        return this.rawReturnComponentType;
    }

    public Class getRawReturnKeyComponentType() {
        return this.rawReturnKeyComponentType;
    }

    public Class resolveRawReturnComponentType(int index) {
        return ReflectUtil.getComponentType(this.returnType, this.classDescriptor.getType(), index);
    }

    public Class[] getRawParameterTypes() {
        return this.rawParameterTypes;
    }
}

