/*
 * Decompiled with CFR 0.152.
 */
package jodd.upload;

import jodd.io.FileNameUtil;

public class FileUploadHeader {
    String dataHeader;
    String formFieldName;
    String formFileName;
    String path;
    String fileName;
    boolean isFile;
    String contentType;
    String mimeType;
    String mimeSubtype;
    String contentDisposition;

    FileUploadHeader(String dataHeader) {
        this.dataHeader = dataHeader;
        this.isFile = dataHeader.indexOf("filename") > 0;
        this.formFieldName = this.getDataFieldValue(dataHeader, "name");
        if (this.isFile) {
            int ls;
            this.formFileName = this.getDataFieldValue(dataHeader, "filename");
            if (this.formFileName == null) {
                return;
            }
            if (this.formFileName.length() == 0) {
                this.path = "";
                this.fileName = "";
            }
            if ((ls = FileNameUtil.indexOfLastSeparator(this.formFileName)) == -1) {
                this.path = "";
                this.fileName = this.formFileName;
            } else {
                this.path = this.formFileName.substring(0, ls);
                this.fileName = this.formFileName.substring(ls);
            }
            if (this.fileName.length() > 0) {
                this.contentType = this.getContentType(dataHeader);
                this.mimeType = this.getMimeType(this.contentType);
                this.mimeSubtype = this.getMimeSubtype(this.contentType);
                this.contentDisposition = this.getContentDisposition(dataHeader);
            }
        }
    }

    private String getDataFieldValue(String dataHeader, String fieldName) {
        String value = null;
        String token = String.valueOf(new StringBuffer(String.valueOf(fieldName)).append('=').append('\"'));
        int pos = dataHeader.indexOf(token);
        if (pos > 0) {
            int start = pos + token.length();
            int end = dataHeader.indexOf(34, start);
            if (start > 0 && end > 0) {
                value = dataHeader.substring(start, end);
            }
        }
        return value;
    }

    private String getContentType(String dataHeader) {
        String token = "Content-Type:";
        int start = dataHeader.indexOf(token);
        if (start == -1) {
            return "";
        }
        return dataHeader.substring(start += token.length());
    }

    private String getContentDisposition(String dataHeader) {
        int start = dataHeader.indexOf(58) + 1;
        int end = dataHeader.indexOf(59);
        return dataHeader.substring(start, end);
    }

    private String getMimeType(String ContentType) {
        int pos = ContentType.indexOf(47);
        if (pos == -1) {
            return ContentType;
        }
        return ContentType.substring(1, pos);
    }

    private String getMimeSubtype(String ContentType) {
        int start = ContentType.indexOf(47);
        if (start == -1) {
            return ContentType;
        }
        return ContentType.substring(++start);
    }

    public boolean isFile() {
        return this.isFile;
    }

    public String getFormFieldName() {
        return this.formFieldName;
    }

    public String getFormFilename() {
        return this.formFileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getMimeSubtype() {
        return this.mimeSubtype;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }
}

