/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge;

public class UrlUtils {
    public static String getPath(String url) {
        if (url == null) {
            return null;
        }
        int i = (url = url.trim()).lastIndexOf(47);
        if (i >= 0) {
            return url.substring(0, i);
        }
        return url;
    }

    public static boolean isRelativeHttp(String url) {
        if (url == null || url.length() == 0) {
            return true;
        }
        return !UrlUtils.isFullHttp(url) && url.charAt(0) != '/';
    }

    public static boolean isAbsoluteHttp(String url) {
        return !UrlUtils.isAbsoluteWithHostHttp(url) && url.charAt(0) == '/';
    }

    public static boolean isAbsoluteWithHostHttp(String url) {
        return url.length() > 1 && url.charAt(0) == '/' && url.charAt(1) == '/';
    }

    public static boolean isFull(String url) {
        int indexOfFirstSlash = url.indexOf(47);
        int indexOfColon = url.indexOf(58);
        return indexOfColon >= 0 && indexOfFirstSlash >= 0 && indexOfColon < indexOfFirstSlash;
    }

    public static boolean isFullHttp(String url) {
        int indexOfFirstSlash = url.indexOf(47);
        int indexOfColon = url.indexOf(58);
        if (indexOfColon >= 0 && indexOfFirstSlash >= 0 && indexOfColon < indexOfFirstSlash) {
            return url.startsWith("http");
        }
        return false;
    }

    public static String safeAppend(String path, String resource) {
        if (resource == null || resource.length() == 0) {
            resource = "/";
        }
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (UrlUtils.isFull(resource)) {
            return resource;
        }
        boolean pathEndsWithSlash = path.charAt(path.length() - 1) == '/';
        boolean resourceStartsWithSlash = resource.charAt(0) == '/';
        return (pathEndsWithSlash ? path.substring(0, path.length() - 1) : path) + "/" + (resourceStartsWithSlash ? resource.substring(1) : resource);
    }

    public static String rewriteRelative(String baseUrl, String resource) {
        if (resource == null) {
            resource = "";
        }
        if ((resource = resource.trim()).length() > 0 && resource.charAt(0) == '/') {
            return resource;
        }
        return UrlUtils.safeAppend(baseUrl, resource);
    }

    public static String getProtocolHostPort(String currentUrl) {
        if (UrlUtils.isFullHttp(currentUrl)) {
            int indexOfThirdSlash = currentUrl.indexOf(47);
            if (indexOfThirdSlash != -1) {
                if ((indexOfThirdSlash = currentUrl.indexOf(47, indexOfThirdSlash + 2)) == -1) {
                    return currentUrl;
                }
                return currentUrl.substring(0, indexOfThirdSlash);
            }
            return null;
        }
        return null;
    }

    public static String getProtocol(String currentUrl) {
        int indexOfColon = currentUrl.indexOf(58);
        if (indexOfColon != -1) {
            return currentUrl.substring(0, indexOfColon);
        }
        return null;
    }
}

