/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.counter.service.persistence;

import com.liferay.counter.model.Counter;
import com.liferay.counter.model.CounterHolder;
import com.liferay.counter.model.CounterRegister;
import com.liferay.counter.model.impl.CounterImpl;
import com.liferay.counter.service.persistence.CounterFinder;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.concurrent.CompeteLatch;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.dao.orm.ObjectNotFoundException;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.Dummy;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CounterFinderImpl
extends BasePersistenceImpl<Dummy>
implements CacheRegistryItem,
CounterFinder {
    private static final int _DEFAULT_CURRENT_ID = 0;
    private static final int _MINIMUM_INCREMENT_SIZE = 1;
    private static final String _NAME = Counter.class.getName();
    private static final String _SQL_INSERT = "insert into Counter(name, currentId) values (?, ?)";
    private static final String _SQL_SELECT_ID_BY_NAME = "select currentId from Counter where name = ?";
    private static final String _SQL_SELECT_NAMES = "select name from Counter order by name asc";
    private static final String _SQL_UPDATE_NAME_BY_NAME = "update Counter set name = ? where name = ?";
    private Map<String, CounterRegister> _counterRegisterMap = new ConcurrentHashMap<String, CounterRegister>();
    private Map<String, Integer> _rangeSizeMap = new ConcurrentHashMap<String, Integer>();

    public void afterPropertiesSet() {
        CacheRegistryUtil.register((CacheRegistryItem)this);
    }

    public List<String> getNames() throws SystemException {
        ArrayList<String> arrayList;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(_SQL_SELECT_NAMES);
            resultSet = preparedStatement.executeQuery();
            ArrayList<String> list = new ArrayList<String>();
            while (resultSet.next()) {
                list.add(resultSet.getString(1));
            }
            arrayList = list;
        }
        catch (SQLException sqle) {
            try {
                throw this.processException(sqle);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        DataAccess.cleanUp((Connection)connection, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList;
    }

    public String getRegistryName() {
        return CounterFinderImpl.class.getName();
    }

    public long increment() throws SystemException {
        return this.increment(_NAME);
    }

    public long increment(String name) throws SystemException {
        return this.increment(name, 1);
    }

    public long increment(String name, int size) throws SystemException {
        if (size < 1) {
            size = 1;
        }
        CounterRegister counterRegister = this.getCounterRegister(name);
        return this._competeIncrement(counterRegister, size);
    }

    public void invalidate() {
        this._counterRegisterMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String oldName, String newName) throws SystemException {
        CounterRegister counterRegister;
        CounterRegister counterRegister2 = counterRegister = this.getCounterRegister(oldName);
        synchronized (counterRegister2) {
            block10: {
                if (this._counterRegisterMap.containsKey(newName)) {
                    throw new SystemException("Cannot rename " + oldName + " to " + newName);
                }
                Connection connection = null;
                PreparedStatement preparedStatement = null;
                try {
                    connection = this.getConnection();
                    preparedStatement = connection.prepareStatement(_SQL_UPDATE_NAME_BY_NAME);
                    preparedStatement.setString(1, newName);
                    preparedStatement.setString(2, oldName);
                    preparedStatement.executeUpdate();
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    DataAccess.cleanUp((Connection)connection, preparedStatement);
                    break block10;
                }
                catch (Exception e2) {
                    try {
                        throw this.processException(e2);
                    }
                    catch (Throwable throwable) {
                        DataAccess.cleanUp((Connection)connection, preparedStatement);
                        throw throwable;
                    }
                }
                DataAccess.cleanUp((Connection)connection, (Statement)preparedStatement);
            }
            counterRegister.setName(newName);
            this._counterRegisterMap.put(newName, counterRegister);
            this._counterRegisterMap.remove(oldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(String name) throws SystemException {
        CounterRegister counterRegister;
        CounterRegister counterRegister2 = counterRegister = this.getCounterRegister(name);
        synchronized (counterRegister2) {
            block9: {
                Session session = null;
                try {
                    session = this.openSession();
                    Counter counter = (Counter)session.get(CounterImpl.class, (Serializable)((Object)name));
                    session.delete((Object)counter);
                    session.flush();
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    this.closeSession(session);
                    break block9;
                }
                catch (Exception e2) {
                    try {
                        throw this.processException(e2);
                    }
                    catch (Throwable throwable) {
                        this.closeSession(session);
                        throw throwable;
                    }
                }
                this.closeSession(session);
            }
            this._counterRegisterMap.remove(name);
        }
    }

    public void reset(String name, long size) throws SystemException {
        CounterRegister counterRegister = this.createCounterRegister(name, size);
        this._counterRegisterMap.put(name, counterRegister);
    }

    protected CounterRegister createCounterRegister(String name) throws SystemException {
        return this.createCounterRegister(name, -1L);
    }

    protected CounterRegister createCounterRegister(String name, long size) throws SystemException {
        long rangeMin = -1L;
        int rangeSize = this.getRangeSize(name);
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement(_SQL_SELECT_ID_BY_NAME);
                preparedStatement.setString(1, name);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    rangeMin = 0L;
                    if (size > rangeMin) {
                        rangeMin = size;
                    }
                    resultSet.close();
                    preparedStatement.close();
                    preparedStatement = connection.prepareStatement(_SQL_INSERT);
                    preparedStatement.setString(1, name);
                    preparedStatement.setLong(2, rangeMin);
                    preparedStatement.executeUpdate();
                }
            }
            catch (Exception e2) {
                throw this.processException(e2);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)connection, preparedStatement, resultSet);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)connection, (Statement)preparedStatement, (ResultSet)resultSet);
        CounterHolder counterHolder = this._obtainIncrement(name, rangeSize, size);
        return new CounterRegister(name, counterHolder, rangeSize);
    }

    protected Connection getConnection() throws SQLException {
        Connection connection = this.getDataSource().getConnection();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CounterRegister getCounterRegister(String name) throws SystemException {
        CounterRegister counterRegister = this._counterRegisterMap.get(name);
        if (counterRegister != null) {
            return counterRegister;
        }
        Map<String, CounterRegister> map = this._counterRegisterMap;
        synchronized (map) {
            counterRegister = this._counterRegisterMap.get(name);
            if (counterRegister == null) {
                counterRegister = this.createCounterRegister(name);
                this._counterRegisterMap.put(name, counterRegister);
            }
            return counterRegister;
        }
    }

    protected int getRangeSize(String name) {
        if (name.equals(_NAME)) {
            return PropsValues.COUNTER_INCREMENT;
        }
        String incrementType = null;
        int pos = name.indexOf(35);
        incrementType = pos != -1 ? name.substring(0, pos) : name;
        Integer rangeSize = this._rangeSizeMap.get(incrementType);
        if (rangeSize == null) {
            rangeSize = GetterUtil.getInteger((String)PropsUtil.get("counter.increment." + incrementType), (int)PropsValues.COUNTER_INCREMENT);
            this._rangeSizeMap.put(incrementType, rangeSize);
        }
        return rangeSize;
    }

    private long _competeIncrement(CounterRegister counterRegister, int size) throws SystemException {
        CounterHolder counterHolder = counterRegister.getCounterHolder();
        long newValue = counterHolder.addAndGet(size);
        if (newValue <= counterHolder.getRangeMax()) {
            return newValue;
        }
        CompeteLatch completeLatch = counterRegister.getCompeteLatch();
        if (!completeLatch.compete()) {
            try {
                completeLatch.await();
            }
            catch (InterruptedException ie) {
                throw this.processException(ie);
            }
            return this._competeIncrement(counterRegister, size);
        }
        try {
            try {
                counterHolder = counterRegister.getCounterHolder();
                newValue = counterHolder.addAndGet(size);
                if (newValue > counterHolder.getRangeMax()) {
                    CounterHolder newCounterHolder = this._obtainIncrement(counterRegister.getName(), counterRegister.getRangeSize(), 0L);
                    newValue = newCounterHolder.addAndGet(size);
                    counterRegister.setCounterHolder(newCounterHolder);
                }
            }
            catch (Exception e2) {
                throw this.processException(e2);
            }
        }
        finally {
            completeLatch.done();
        }
        return newValue;
    }

    private CounterHolder _obtainIncrement(String counterName, long range, long size) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            Counter counter = (Counter)session.get(CounterImpl.class, (Serializable)((Object)counterName), LockMode.UPGRADE);
            long newValue = counter.getCurrentId();
            if (size > newValue) {
                newValue = size;
            }
            long rangeMax = newValue + range;
            counter.setCurrentId(rangeMax);
            CounterHolder counterHolder = new CounterHolder(newValue, rangeMax);
            session.saveOrUpdate((Object)counter);
            session.flush();
            CounterHolder counterHolder2 = counterHolder;
            return counterHolder2;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }
}

