/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.memory;

import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.CacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.concurrent.ConcurrentHashSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryPortalCache<K extends Serializable, V>
implements PortalCache<K, V> {
    private Set<CacheListener<K, V>> _cacheListeners = new ConcurrentHashSet();
    private Map<K, V> _map;
    private String _name;

    public MemoryPortalCache(String name, int initialCapacity) {
        this._name = name;
        this._map = new ConcurrentHashMap(initialCapacity);
    }

    public void destroy() {
        this.removeAll();
        this._cacheListeners = null;
        this._map = null;
        this._name = null;
    }

    public Collection<V> get(Collection<K> keys) {
        ArrayList<V> values = new ArrayList<V>(keys.size());
        for (Serializable key : keys) {
            values.add(this.get(key));
        }
        return values;
    }

    public V get(K key) {
        return this._map.get(key);
    }

    public List<K> getKeys() {
        return new ArrayList<K>(this._map.keySet());
    }

    public String getName() {
        return this._name;
    }

    public void put(K key, V value) {
        V oldValue = this._map.put(key, value);
        this.notifyPutEvents(key, value, oldValue != null);
    }

    public void put(K key, V value, int timeToLive) {
        V oldValue = this._map.put(key, value);
        this.notifyPutEvents(key, value, oldValue != null);
    }

    public void registerCacheListener(CacheListener<K, V> cacheListener) {
        this._cacheListeners.add(cacheListener);
    }

    public void registerCacheListener(CacheListener<K, V> cacheListener, CacheListenerScope cacheListenerScope) {
        this.registerCacheListener(cacheListener);
    }

    public void remove(K key) {
        V value = this._map.remove(key);
        for (CacheListener<K, V> cacheListener : this._cacheListeners) {
            cacheListener.notifyEntryRemoved((PortalCache)this, key, value);
        }
    }

    public void removeAll() {
        this._map.clear();
        for (CacheListener<K, V> cacheListener : this._cacheListeners) {
            cacheListener.notifyRemoveAll((PortalCache)this);
        }
    }

    public void unregisterCacheListener(CacheListener<K, V> cacheListener) {
        this._cacheListeners.remove(cacheListener);
    }

    public void unregisterCacheListeners() {
        this._cacheListeners.clear();
    }

    protected void notifyPutEvents(K key, V value, boolean updated) {
        if (updated) {
            for (CacheListener<K, V> cacheListener : this._cacheListeners) {
                cacheListener.notifyEntryUpdated((PortalCache)this, key, value);
            }
        } else {
            for (CacheListener<K, V> cacheListener : this._cacheListeners) {
                cacheListener.notifyEntryPut((PortalCache)this, key, value);
            }
        }
    }
}

