/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.easyconf;

import com.germinus.easyconf.AggregatedProperties;
import com.germinus.easyconf.ComponentConfiguration;
import com.germinus.easyconf.ComponentProperties;
import com.germinus.easyconf.ConfigurationNotFoundException;
import com.liferay.portal.configuration.easyconf.ClassLoaderAggregateProperties;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import java.lang.reflect.Constructor;

public class ClassLoaderComponentConfiguration
extends ComponentConfiguration {
    private static Log _log = LogFactoryUtil.getLog(ClassLoaderComponentConfiguration.class);
    private static Constructor<ComponentProperties> _constructor;
    private ClassLoader _classLoader;
    private String _companyId;
    private String _componentName;
    private ComponentProperties _properties;

    static {
        try {
            _constructor = ComponentProperties.class.getDeclaredConstructor(AggregatedProperties.class);
            _constructor.setAccessible(true);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public ClassLoaderComponentConfiguration(ClassLoader classLoader, String companyId, String componentName) {
        super(companyId, componentName);
        this._classLoader = classLoader;
        this._companyId = companyId;
        this._componentName = componentName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ComponentConfiguration)) {
            return false;
        }
        ComponentConfiguration componentConfiguration = (ComponentConfiguration)obj;
        return this._componentName.equals(componentConfiguration.getComponentName());
    }

    public String getComponentName() {
        return this._componentName;
    }

    public Object getConfigurationObject() {
        throw new UnsupportedOperationException();
    }

    public Object getConfigurationObject(String configurationName) {
        throw new UnsupportedOperationException();
    }

    public ComponentProperties getProperties() {
        ComponentProperties componentProperties = this._getAvailableProperties();
        if (!componentProperties.hasBaseConfiguration()) {
            throw new ConfigurationNotFoundException(this._componentName, "The base properties file was not found");
        }
        return componentProperties;
    }

    public int hashCode() {
        return this._componentName.hashCode();
    }

    public void saveConfigurationObject(Object configurationObject) {
        throw new UnsupportedOperationException();
    }

    public void saveConfigurationObject(String confName, Object configurationObject) {
        throw new UnsupportedOperationException();
    }

    private ComponentProperties _getAvailableProperties() {
        if (this._properties != null) {
            return this._properties;
        }
        SystemProperties.set((String)"base.path", (String)".");
        ClassLoaderAggregateProperties classLoaderAggregateProperties = new ClassLoaderAggregateProperties(this._classLoader, this._companyId, this._componentName);
        classLoaderAggregateProperties.addGlobalFileName("global-configuration.properties");
        classLoaderAggregateProperties.addBaseFileName(String.valueOf(this._componentName) + ".properties");
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Properties for " + this._componentName + " loaded from " + classLoaderAggregateProperties.loadedSources()));
        }
        try {
            this._properties = _constructor.newInstance(new Object[]{classLoaderAggregateProperties});
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return this._properties;
    }
}

