/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.SessionAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.ChannelException;
import com.liferay.portal.kernel.notifications.ChannelHubManagerUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import javax.servlet.http.HttpSession;

public class ChannelSessionDestroyAction
extends SessionAction {
    private static Log _log = LogFactoryUtil.getLog(ChannelSessionDestroyAction.class);

    public void run(HttpSession session) {
        User user = null;
        try {
            user = (User)session.getAttribute("USER");
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        try {
            Long userId;
            if (user == null && (userId = (Long)session.getAttribute("USER_ID")) != null) {
                user = UserLocalServiceUtil.getUser((long)userId);
            }
            if (user == null || user.isDefaultUser()) {
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Destroying channel " + user.getUserId()));
            }
            try {
                ChannelHubManagerUtil.destroyChannel((long)user.getCompanyId(), (long)user.getUserId());
            }
            catch (ChannelException ce) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("User channel " + user.getUserId() + " is already unregistered"), (Throwable)ce);
                }
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }
}

