/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.freemarker;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.template.TemplateResourceThreadLocal;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import freemarker.cache.TemplateCache;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;

public class LiferayTemplateCache
extends TemplateCache {
    private Configuration _configuration;
    private PortalCache<TemplateResource, Object> _portalCache;

    public LiferayTemplateCache(Configuration configuration) {
        this._configuration = configuration;
        String cacheName = TemplateResource.class.getName();
        cacheName = cacheName.concat("#").concat("ftl");
        this._portalCache = SingleVMPoolUtil.getCache((String)cacheName);
    }

    public Template getTemplate(String templateId, Locale locale, String encoding, boolean parse) throws IOException {
        String[] macroTemplateIds;
        String[] stringArray = macroTemplateIds = PropsUtil.getArray("freemarker.engine.macro.library");
        int n = macroTemplateIds.length;
        int n2 = 0;
        while (n2 < n) {
            String macroTemplateId = stringArray[n2];
            int pos = macroTemplateId.indexOf(" as ");
            if (pos != -1) {
                macroTemplateId = macroTemplateId.substring(0, pos);
            }
            if (templateId.equals(macroTemplateId)) {
                try {
                    return AccessController.doPrivileged(new TemplatePrivilegedExceptionAction(macroTemplateId, locale, encoding, parse));
                }
                catch (PrivilegedActionException pae) {
                    throw (IOException)pae.getException();
                }
            }
            ++n2;
        }
        return this.doGetTemplate(templateId, locale, encoding, parse);
    }

    private Template doGetTemplate(String templateId, Locale locale, String encoding, boolean parse) throws IOException {
        if (templateId == null) {
            throw new IllegalArgumentException("Argument \"name\" is null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Argument \"locale\" is null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("Argument \"encoding\" is null");
        }
        TemplateResource templateResource = null;
        if (templateId.startsWith("TEMPLATE_RESOURCE_UUID")) {
            templateResource = TemplateResourceThreadLocal.getTemplateResource("ftl");
        } else {
            try {
                templateResource = TemplateResourceLoaderUtil.getTemplateResource((String)"ftl", (String)templateId);
            }
            catch (Exception exception) {
                templateResource = null;
            }
        }
        if (templateResource == null) {
            throw new IOException("Unable to find FreeMarker template with ID " + templateId);
        }
        Object object = this._portalCache.get((Serializable)templateResource);
        if (object != null && object instanceof Template) {
            return (Template)object;
        }
        Template template = new Template(templateResource.getTemplateId(), templateResource.getReader(), this._configuration, "UTF-8");
        if (PropsValues.FREEMARKER_ENGINE_RESOURCE_MODIFICATION_CHECK_INTERVAL != 0) {
            this._portalCache.put((Serializable)templateResource, (Object)template);
        }
        return template;
    }

    private class TemplatePrivilegedExceptionAction
    implements PrivilegedExceptionAction<Template> {
        private String _encoding;
        private Locale _locale;
        private boolean _parse;
        private String _templateId;

        public TemplatePrivilegedExceptionAction(String templateId, Locale locale, String encoding, boolean parse) {
            this._templateId = templateId;
            this._locale = locale;
            this._encoding = encoding;
            this._parse = parse;
        }

        @Override
        public Template run() throws Exception {
            return LiferayTemplateCache.this.doGetTemplate(this._templateId, this._locale, this._encoding, this._parse);
        }
    }
}

