/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.transformer;

import com.liferay.portal.json.transformer.FlexjsonObjectJSONTransformer;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.permission.UserPermissionUtil;

public class UserJSONTransformer
extends FlexjsonObjectJSONTransformer {
    @Override
    public void transform(Object object) {
        User user = (User)object;
        boolean hidePrivateUserData = true;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null && (user.getUserId() == permissionChecker.getUserId() || UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)user.getUserId(), (String)"VIEW"))) {
            hidePrivateUserData = false;
        }
        if (hidePrivateUserData) {
            user.setPasswordUnencrypted("");
            user.setReminderQueryQuestion("");
            user.setReminderQueryAnswer("");
            user.setEmailAddress("");
            user.setFacebookId(0L);
            user.setComments("");
        }
        super.transform(object);
    }
}

