/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging;

import com.liferay.portal.kernel.messaging.BaseMessageStatusMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageStatus;
import com.liferay.portal.kernel.messaging.sender.MessageSender;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSender;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.messaging.LayoutsLocalPublisherRequest;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LayoutsLocalPublisherMessageListener
extends BaseMessageStatusMessageListener {
    public LayoutsLocalPublisherMessageListener() {
    }

    public LayoutsLocalPublisherMessageListener(SingleDestinationMessageSender statusSender, MessageSender responseSender) {
        super(statusSender, responseSender);
    }

    protected void doReceive(Message message, MessageStatus messageStatus) throws Exception {
        int last;
        LayoutsLocalPublisherRequest publisherRequest = (LayoutsLocalPublisherRequest)message.getPayload();
        messageStatus.setPayload((Object)publisherRequest);
        String command = publisherRequest.getCommand();
        long userId = publisherRequest.getUserId();
        long sourceGroupId = publisherRequest.getSourceGroupId();
        long targetGroupId = publisherRequest.getTargetGroupId();
        boolean privateLayout = publisherRequest.isPrivateLayout();
        Map<Long, Boolean> layoutIdMap = publisherRequest.getLayoutIdMap();
        Map<String, String[]> parameterMap = publisherRequest.getParameterMap();
        Date startDate = publisherRequest.getStartDate();
        Date endDate = publisherRequest.getEndDate();
        String range = MapUtil.getString(parameterMap, (String)"range");
        if (range.equals("fromLastPublishDate")) {
            LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)sourceGroupId, (boolean)privateLayout);
            long lastPublishDate = GetterUtil.getLong((String)layoutSet.getSettingsProperty("last-publish-date"));
            if (lastPublishDate > 0L) {
                endDate = new Date();
                startDate = new Date(lastPublishDate);
            }
        } else if (range.equals("last") && (last = MapUtil.getInteger(parameterMap, (String)"last")) > 0) {
            Date scheduledFireTime = publisherRequest.getScheduledFireTime();
            if (scheduledFireTime == null) {
                scheduledFireTime = new Date();
            }
            startDate = new Date(scheduledFireTime.getTime() - (long)last * 3600000L);
            endDate = scheduledFireTime;
        }
        PrincipalThreadLocal.setName((long)userId);
        User user = UserLocalServiceUtil.getUserById((long)userId);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setPathMain(PortalUtil.getPathMain());
        serviceContext.setSignedIn(!user.isDefaultUser());
        serviceContext.setUserId(user.getUserId());
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String param = entry.getKey();
            Object[] values = entry.getValue();
            if (!ArrayUtil.isNotEmpty((Object[])values)) continue;
            if (values.length == 1) {
                attributes.put(param, values[0]);
                continue;
            }
            attributes.put(param, values);
        }
        serviceContext.setAttributes(attributes);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        try {
            if (command.equals("ALL_PAGES")) {
                StagingUtil.publishLayouts((long)userId, (long)sourceGroupId, (long)targetGroupId, (boolean)privateLayout, parameterMap, (Date)startDate, (Date)endDate);
            } else if (command.equals("SELECTED_PAGES")) {
                StagingUtil.publishLayouts((long)userId, (long)sourceGroupId, (long)targetGroupId, (boolean)privateLayout, layoutIdMap, parameterMap, (Date)startDate, (Date)endDate);
            }
        }
        finally {
            PrincipalThreadLocal.setName(null);
            PermissionThreadLocal.setPermissionChecker(null);
        }
    }
}

