/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.pop.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.pop.MessageListenerException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.pop.POPServerUtil;
import com.liferay.util.mail.MailEngine;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;

public class POPNotificationsMessageListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(POPNotificationsMessageListener.class);

    protected void doReceive(Message message) throws MessagingException {
        Store store = null;
        try {
            store = this.getStore();
            Folder inboxFolder = this.getInboxFolder(store);
            if (inboxFolder == null) {
                return;
            }
            try {
                javax.mail.Message[] messages = inboxFolder.getMessages();
                if (messages == null) {
                    return;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Deleting messages");
                }
                inboxFolder.setFlags(messages, new Flags(Flags.Flag.DELETED), true);
                this.notifyMessageListeners(messages);
            }
            finally {
                inboxFolder.close(true);
            }
        }
        finally {
            if (store != null) {
                store.close();
            }
        }
    }

    protected String getEmailAddress(Address[] addresses) {
        if (ArrayUtil.isEmpty((Object[])addresses)) {
            return "";
        }
        InternetAddress internetAddress = (InternetAddress)addresses[0];
        return internetAddress.getAddress();
    }

    protected Folder getInboxFolder(Store store) throws MessagingException {
        Folder defaultFolder = store.getDefaultFolder();
        Folder[] folders = defaultFolder.list();
        if (folders.length == 0) {
            throw new MessagingException("Inbox not found");
        }
        Folder inboxFolder = folders[0];
        inboxFolder.open(2);
        return inboxFolder;
    }

    protected Store getStore() throws MessagingException {
        String password;
        Session session = MailEngine.getSession();
        String storeProtocol = GetterUtil.getString((String)session.getProperty("mail.store.protocol"));
        if (!storeProtocol.equals("pop3s")) {
            storeProtocol = "pop3";
        }
        Store store = session.getStore(storeProtocol);
        String prefix = "mail." + storeProtocol + ".";
        String host = session.getProperty(String.valueOf(prefix) + "host");
        String user = session.getProperty(String.valueOf(prefix) + "user");
        if (Validator.isNull((String)user)) {
            user = session.getProperty("mail.smtp.user");
        }
        if (Validator.isNull((String)(password = session.getProperty(String.valueOf(prefix) + "password")))) {
            password = session.getProperty("mail.smtp.password");
        }
        store.connect(host, user, password);
        return store;
    }

    protected void notifyMessageListeners(javax.mail.Message[] messages) throws MessagingException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Messages " + messages.length));
        }
        javax.mail.Message[] messageArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            javax.mail.Message message = messageArray[n2];
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Message " + message));
            }
            String from = this.getEmailAddress(message.getFrom());
            String recipient = this.getEmailAddress(message.getRecipients(Message.RecipientType.TO));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("From " + from));
                _log.debug((Object)("Recipient " + recipient));
            }
            for (MessageListener messageListener : POPServerUtil.getListeners()) {
                try {
                    if (!messageListener.accept(from, recipient, message)) continue;
                    messageListener.deliver(from, recipient, message);
                }
                catch (MessageListenerException mle) {
                    _log.error((Object)mle, (Throwable)mle);
                }
            }
            ++n2;
        }
    }
}

