/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ac;

import com.liferay.portal.security.ac.AccessControl;
import com.liferay.portal.security.ac.AccessControlAdvisor;
import com.liferay.portal.security.ac.AccessControlThreadLocal;
import com.liferay.portal.security.ac.AccessControlled;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public class AccessControlAdvice
extends AnnotationChainableMethodAdvice<AccessControlled> {
    private AccessControlAdvisor _accessControlAdvisor;

    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        AccessControlled accessControlled = (AccessControlled)this.findAnnotation(methodInvocation);
        if (accessControlled == AccessControl.NULL_ACCESS_CONTROLLED) {
            return null;
        }
        boolean remoteAccess = AccessControlThreadLocal.isRemoteAccess();
        if (remoteAccess) {
            Method targetMethod = methodInvocation.getMethod();
            this._accessControlAdvisor.accept(targetMethod, accessControlled);
        }
        return null;
    }

    @Override
    public AccessControlled getNullAnnotation() {
        return AccessControl.NULL_ACCESS_CONTROLLED;
    }

    public void setAccessControlAdvisor(AccessControlAdvisor accessControlAdvisor) {
        this._accessControlAdvisor = accessControlAdvisor;
    }
}

