/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.PwdEncryptorException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pwd.BasePasswordEncryptor;
import com.liferay.portal.security.pwd.PasswordEncryptor;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import org.vps.crypt.Crypt;

public class CryptPasswordEncryptor
extends BasePasswordEncryptor
implements PasswordEncryptor {
    private static final String[] _SALT = ArrayUtil.toStringArray((char[])"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789./".toCharArray());

    public String[] getSupportedAlgorithmTypes() {
        return new String[]{"CRYPT", "UFC-CRYPT"};
    }

    @Override
    protected String doEncrypt(String algorithm, String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        byte[] saltBytes = this.getSalt(encryptedPassword);
        try {
            return Crypt.crypt((byte[])saltBytes, (byte[])plainTextPassword.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new PwdEncryptorException(uee.getMessage(), (Throwable)uee);
        }
    }

    protected byte[] getSalt(String encryptedPassword) throws PwdEncryptorException {
        byte[] saltBytes = null;
        try {
            if (Validator.isNull((String)encryptedPassword)) {
                Random random = new Random();
                int x = random.nextInt(Integer.MAX_VALUE) % _SALT.length;
                int y = random.nextInt(Integer.MAX_VALUE) % _SALT.length;
                String salt = _SALT[x].concat(_SALT[y]);
                saltBytes = salt.getBytes("UTF-8");
            } else {
                String salt = encryptedPassword.substring(0, 2);
                saltBytes = salt.getBytes("UTF-8");
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new PwdEncryptorException("Unable to extract salt from encrypted password " + uee.getMessage(), (Throwable)uee);
        }
        return saltBytes;
    }
}

