/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.RemoteExportException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.LayoutStagingHandler;
import com.liferay.portal.model.Repository;
import com.liferay.portal.model.User;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryThreadLocal;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.RemoteAuthException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.StagingLocalServiceBaseImpl;
import com.liferay.portal.service.http.GroupServiceHttp;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelNameComparator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequest;

public class StagingLocalServiceImpl
extends StagingLocalServiceBaseImpl {
    private static final String _ASSEMBLED_LAR_PREFIX = "assembled_";
    private static Log _log = LogFactoryUtil.getLog(StagingLocalServiceImpl.class);

    public void checkDefaultLayoutSetBranches(long userId, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, boolean remote, ServiceContext serviceContext) throws PortalException, SystemException {
        long targetGroupId = 0L;
        if (remote) {
            targetGroupId = liveGroup.getGroupId();
        } else {
            Group stagingGroup = liveGroup.getStagingGroup();
            if (stagingGroup == null) {
                return;
            }
            targetGroupId = stagingGroup.getGroupId();
        }
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchLocalService.fetchLayoutSetBranch(targetGroupId, false, "main-variation");
        if (branchingPublic && layoutSetBranch == null) {
            this.addDefaultLayoutSetBranch(userId, targetGroupId, liveGroup.getDescriptiveName(), false, serviceContext);
        } else if (!branchingPublic && layoutSetBranch != null) {
            this.deleteLayoutSetBranches(targetGroupId, false);
        } else if (layoutSetBranch != null) {
            this.clearLastPublishDate(targetGroupId, false);
        }
        layoutSetBranch = this.layoutSetBranchLocalService.fetchLayoutSetBranch(targetGroupId, true, "main-variation");
        if (branchingPrivate && layoutSetBranch == null) {
            this.addDefaultLayoutSetBranch(userId, targetGroupId, liveGroup.getDescriptiveName(), true, serviceContext);
        } else if (!branchingPrivate && layoutSetBranch != null) {
            this.deleteLayoutSetBranches(targetGroupId, true);
        } else if (layoutSetBranch != null) {
            this.clearLastPublishDate(targetGroupId, false);
        }
    }

    public void cleanUpStagingRequest(long stagingRequestId) throws PortalException, SystemException {
        block2: {
            try {
                PortletFileRepositoryUtil.deleteFolder((long)stagingRequestId);
            }
            catch (NoSuchFolderException nsfe) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)("Unable to clean up staging request " + stagingRequestId), (Throwable)nsfe);
            }
        }
    }

    public long createStagingRequest(long userId, long groupId, String checksum) throws PortalException, SystemException {
        ServiceContext serviceContext = new ServiceContext();
        Repository repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)"134", (ServiceContext)serviceContext);
        Folder folder = PortletFileRepositoryUtil.addPortletFolder((long)userId, (long)repository.getRepositoryId(), (long)0L, (String)checksum, (ServiceContext)serviceContext);
        return folder.getFolderId();
    }

    public void disableStaging(Group liveGroup, ServiceContext serviceContext) throws PortalException, SystemException {
        this.disableStaging(null, liveGroup, serviceContext);
    }

    public void disableStaging(PortletRequest portletRequest, Group liveGroup, ServiceContext serviceContext) throws PortalException, SystemException {
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        boolean stagedRemotely = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("stagedRemotely"));
        if (stagedRemotely) {
            String remoteURL = StagingUtil.buildRemoteURL((UnicodeProperties)typeSettingsProperties);
            long remoteGroupId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("remoteGroupId"));
            boolean forceDisable = GetterUtil.getBoolean((Object)serviceContext.getAttribute("forceDisable"));
            this.disableRemoteStaging(remoteURL, remoteGroupId, forceDisable);
        }
        typeSettingsProperties.remove((Object)"branchingPrivate");
        typeSettingsProperties.remove((Object)"branchingPublic");
        typeSettingsProperties.remove((Object)"remoteAddress");
        typeSettingsProperties.remove((Object)"remoteGroupId");
        typeSettingsProperties.remove((Object)"remotePathContext");
        typeSettingsProperties.remove((Object)"remotePort");
        typeSettingsProperties.remove((Object)"secureConnection");
        typeSettingsProperties.remove((Object)"staged");
        typeSettingsProperties.remove((Object)"stagedRemotely");
        HashSet<String> keys = new HashSet<String>();
        for (String key : typeSettingsProperties.keySet()) {
            if (!key.startsWith("staged-portlet_")) continue;
            keys.add(key);
        }
        for (String key : keys) {
            typeSettingsProperties.remove((Object)key);
        }
        StagingUtil.deleteLastImportSettings((Group)liveGroup, (boolean)true);
        StagingUtil.deleteLastImportSettings((Group)liveGroup, (boolean)false);
        this.checkDefaultLayoutSetBranches(serviceContext.getUserId(), liveGroup, false, false, stagedRemotely, serviceContext);
        if (liveGroup.hasStagingGroup()) {
            Group stagingGroup = liveGroup.getStagingGroup();
            this.groupLocalService.deleteGroup(stagingGroup.getGroupId());
            liveGroup.clearStagingGroup();
        }
        this.groupLocalService.updateGroup(liveGroup.getGroupId(), typeSettingsProperties.toString());
    }

    public void enableLocalStaging(long userId, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, ServiceContext serviceContext) throws PortalException, SystemException {
        if (liveGroup.isStagedRemotely()) {
            this.disableStaging(liveGroup, serviceContext);
        }
        if (!liveGroup.hasStagingGroup()) {
            serviceContext.setAttribute("staging", (Serializable)((Object)String.valueOf(true)));
            Group stagingGroup = this.addStagingGroup(userId, liveGroup, serviceContext);
            Map parameterMap = StagingUtil.getStagingParameters();
            if (liveGroup.hasPrivateLayouts()) {
                StagingUtil.publishLayouts((long)userId, (long)liveGroup.getGroupId(), (long)stagingGroup.getGroupId(), (boolean)true, (Map)parameterMap, null, null);
            }
            if (liveGroup.hasPublicLayouts() || !liveGroup.hasPrivateLayouts()) {
                StagingUtil.publishLayouts((long)userId, (long)liveGroup.getGroupId(), (long)stagingGroup.getGroupId(), (boolean)false, (Map)parameterMap, null, null);
            }
        }
        this.checkDefaultLayoutSetBranches(userId, liveGroup, branchingPublic, branchingPrivate, false, serviceContext);
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("branchingPrivate", String.valueOf(branchingPrivate));
        typeSettingsProperties.setProperty("branchingPublic", String.valueOf(branchingPublic));
        typeSettingsProperties.setProperty("staged", Boolean.TRUE.toString());
        typeSettingsProperties.setProperty("stagedRemotely", String.valueOf(false));
        this.setCommonStagingOptions(liveGroup, typeSettingsProperties, serviceContext);
        this.groupLocalService.updateGroup(liveGroup.getGroupId(), typeSettingsProperties.toString());
    }

    public void enableRemoteStaging(long userId, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, ServiceContext serviceContext) throws PortalException, SystemException {
        StagingUtil.validateRemote((String)remoteAddress, (int)remotePort, (String)remotePathContext, (boolean)secureConnection, (long)remoteGroupId);
        if (liveGroup.hasStagingGroup()) {
            this.disableStaging(liveGroup, serviceContext);
        }
        String remoteURL = StagingUtil.buildRemoteURL((String)remoteAddress, (int)remotePort, (String)remotePathContext, (boolean)secureConnection, (long)0L, (boolean)false);
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        boolean stagedRemotely = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("stagedRemotely"));
        if (stagedRemotely) {
            long oldRemoteGroupId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("remoteGroupId"));
            String oldRemoteURL = StagingUtil.buildRemoteURL((UnicodeProperties)typeSettingsProperties);
            if (!remoteURL.equals(oldRemoteURL) || remoteGroupId != oldRemoteGroupId) {
                this.disableRemoteStaging(oldRemoteURL, oldRemoteGroupId, false);
                stagedRemotely = false;
            }
        }
        if (!stagedRemotely) {
            this.enableRemoteStaging(remoteURL, remoteGroupId);
        }
        this.checkDefaultLayoutSetBranches(userId, liveGroup, branchingPublic, branchingPrivate, true, serviceContext);
        typeSettingsProperties.setProperty("branchingPrivate", String.valueOf(branchingPrivate));
        typeSettingsProperties.setProperty("branchingPublic", String.valueOf(branchingPublic));
        typeSettingsProperties.setProperty("remoteAddress", remoteAddress);
        typeSettingsProperties.setProperty("remoteGroupId", String.valueOf(remoteGroupId));
        typeSettingsProperties.setProperty("remotePathContext", remotePathContext);
        typeSettingsProperties.setProperty("remotePort", String.valueOf(remotePort));
        typeSettingsProperties.setProperty("secureConnection", String.valueOf(secureConnection));
        typeSettingsProperties.setProperty("staged", Boolean.TRUE.toString());
        typeSettingsProperties.setProperty("stagedRemotely", Boolean.TRUE.toString());
        this.setCommonStagingOptions(liveGroup, typeSettingsProperties, serviceContext);
        this.groupLocalService.updateGroup(liveGroup.getGroupId(), typeSettingsProperties.toString());
        this.updateStagedPortlets(remoteURL, remoteGroupId, typeSettingsProperties);
    }

    public void publishStagingRequest(long userId, long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException, SystemException {
        try {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)true);
            ExportImportThreadLocal.setLayoutStagingInProcess((boolean)true);
            Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)stagingRequestId);
            FileEntry stagingRequestFileEntry = this.getStagingRequestFileEntry(userId, stagingRequestId, folder);
            this.layoutLocalService.importLayouts(userId, folder.getGroupId(), privateLayout, parameterMap, stagingRequestFileEntry.getContentStream());
        }
        finally {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)false);
            ExportImportThreadLocal.setLayoutStagingInProcess((boolean)false);
        }
    }

    public void updateStagingRequest(long userId, long stagingRequestId, String fileName, byte[] bytes) throws PortalException, SystemException {
        Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)stagingRequestId);
        PortletFileRepositoryUtil.addPortletFileEntry((long)folder.getGroupId(), (long)userId, (String)Group.class.getName(), (long)folder.getGroupId(), (String)"134", (long)folder.getFolderId(), (InputStream)new UnsyncByteArrayInputStream(bytes), (String)fileName, (String)"application/zip", (boolean)false);
    }

    public MissingReferences validateStagingRequest(long userId, long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException, SystemException {
        try {
            ExportImportThreadLocal.setLayoutValidationInProcess((boolean)true);
            Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)stagingRequestId);
            FileEntry fileEntry = this.getStagingRequestFileEntry(userId, stagingRequestId, folder);
            MissingReferences missingReferences = this.layoutLocalService.validateImportLayoutsFile(userId, folder.getGroupId(), privateLayout, parameterMap, fileEntry.getContentStream());
            return missingReferences;
        }
        finally {
            ExportImportThreadLocal.setLayoutValidationInProcess((boolean)false);
        }
    }

    protected void addDefaultLayoutSetBranch(long userId, long groupId, String groupName, boolean privateLayout, ServiceContext serviceContext) throws PortalException, SystemException {
        block4: {
            String masterBranchDescription = "main-site-pages-variation-of-x";
            if (privateLayout) {
                masterBranchDescription = "main-site-pages-variation-of-x";
            }
            String description = LanguageUtil.format((Locale)PortalUtil.getSiteDefaultLocale((long)groupId), (String)masterBranchDescription, (Object)groupName, (boolean)false);
            try {
                serviceContext.setWorkflowAction(0);
                LayoutSetBranch layoutSetBranch = this.layoutSetBranchLocalService.addLayoutSetBranch(userId, groupId, privateLayout, "main-variation", description, true, 0L, serviceContext);
                List layoutRevisions = this.layoutRevisionLocalService.getLayoutRevisions(layoutSetBranch.getLayoutSetBranchId(), false);
                for (LayoutRevision layoutRevision : layoutRevisions) {
                    this.layoutRevisionLocalService.updateStatus(userId, layoutRevision.getLayoutRevisionId(), 0, serviceContext);
                }
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to create master branch for " + (privateLayout ? "private" : "public") + " layouts"), (Throwable)pe);
            }
        }
    }

    protected Group addStagingGroup(long userId, Group liveGroup, ServiceContext serviceContext) throws PortalException, SystemException {
        long parentGroupId = 0L;
        if (liveGroup.getParentGroupId() != 0L) {
            Group parentGroup = liveGroup.getParentGroup();
            if (parentGroup.hasStagingGroup()) {
                parentGroup = parentGroup.getStagingGroup();
            }
            parentGroupId = parentGroup.getGroupId();
        }
        Group stagingGroup = this.groupLocalService.addGroup(userId, parentGroupId, liveGroup.getClassName(), liveGroup.getClassPK(), liveGroup.getGroupId(), liveGroup.getDescriptiveName(), liveGroup.getDescription(), liveGroup.getType(), liveGroup.isManualMembership(), liveGroup.getMembershipRestriction(), liveGroup.getFriendlyURL(), false, liveGroup.isActive(), serviceContext);
        if (LanguageUtil.isInheritLocales((long)liveGroup.getGroupId())) {
            return stagingGroup;
        }
        UnicodeProperties liveTypeSettingsProperties = liveGroup.getTypeSettingsProperties();
        UnicodeProperties stagingTypeSettingsProperties = stagingGroup.getTypeSettingsProperties();
        stagingTypeSettingsProperties.setProperty("inheritLocales", Boolean.FALSE.toString());
        stagingTypeSettingsProperties.setProperty("locales", liveTypeSettingsProperties.getProperty("locales"));
        stagingTypeSettingsProperties.setProperty("languageId", liveTypeSettingsProperties.getProperty("languageId", LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault())));
        return this.groupLocalService.updateGroup(stagingGroup.getGroupId(), stagingTypeSettingsProperties.toString());
    }

    protected void clearLastPublishDate(long groupId, boolean privateLayout) throws PortalException, SystemException {
        LayoutSet layoutSet = this.layoutSetLocalService.getLayoutSet(groupId, privateLayout);
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        settingsProperties.remove((Object)"last-publish-date");
        this.layoutSetLocalService.updateSettings(groupId, privateLayout, settingsProperties.toString());
    }

    protected void deleteLayoutSetBranches(long groupId, boolean privateLayout) throws PortalException, SystemException {
        HashMap<Long, LayoutRevision> layoutRevisions = new HashMap<Long, LayoutRevision>();
        List layoutSetBranches = this.layoutSetBranchLocalService.getLayoutSetBranches(groupId, privateLayout);
        for (LayoutSetBranch layoutSetBranch : layoutSetBranches) {
            String lastPublishDateString = layoutSetBranch.getSettingsProperty("last-publish-date");
            if (Validator.isNull((String)lastPublishDateString)) continue;
            Date lastPublishDate = new Date(GetterUtil.getLong((String)lastPublishDateString));
            List headLayoutRevisions = this.layoutRevisionLocalService.getLayoutRevisions(layoutSetBranch.getLayoutSetBranchId(), true);
            for (LayoutRevision headLayoutRevision : headLayoutRevisions) {
                LayoutRevision layoutRevision = (LayoutRevision)layoutRevisions.get(headLayoutRevision.getPlid());
                if (layoutRevision == null) {
                    layoutRevisions.put(headLayoutRevision.getPlid(), headLayoutRevision);
                    continue;
                }
                Date statusDate = headLayoutRevision.getStatusDate();
                if (!statusDate.after(layoutRevision.getStatusDate()) || !lastPublishDate.after(statusDate)) continue;
                layoutRevisions.put(headLayoutRevision.getPlid(), headLayoutRevision);
            }
        }
        for (LayoutRevision layoutRevision : layoutRevisions.values()) {
            this.updateLayoutWithLayoutRevision(layoutRevision);
        }
        this.layoutSetBranchLocalService.deleteLayoutSetBranches(groupId, privateLayout, true);
    }

    protected void disableRemoteStaging(String remoteURL, long remoteGroupId) throws PortalException {
        this.disableRemoteStaging(remoteURL, remoteGroupId, false);
    }

    protected void disableRemoteStaging(String remoteURL, long remoteGroupId, boolean forceDisable) throws PortalException {
        block7: {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            User user = permissionChecker.getUser();
            HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getScreenName(), user.getPassword(), user.getPasswordEncrypted());
            try {
                GroupServiceHttp.disableStaging(httpPrincipal, remoteGroupId);
            }
            catch (NoSuchGroupException nsge) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Remote live group was already deleted", (Throwable)nsge);
                }
            }
            catch (PrincipalException principalException) {
                RemoteExportException ree = new RemoteExportException(4);
                ree.setGroupId(remoteGroupId);
                throw ree;
            }
            catch (RemoteAuthException rae) {
                rae.setURL(remoteURL);
                throw rae;
            }
            catch (SystemException systemException) {
                if (!forceDisable) {
                    RemoteExportException ree = new RemoteExportException(1);
                    ree.setURL(remoteURL);
                    throw ree;
                }
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)"Forcibly disable remote staging");
            }
        }
    }

    protected void enableRemoteStaging(String remoteURL, long remoteGroupId) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getScreenName(), user.getPassword(), user.getPasswordEncrypted());
        try {
            GroupServiceHttp.enableStaging(httpPrincipal, remoteGroupId);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            RemoteExportException ree = new RemoteExportException(2);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (PrincipalException principalException) {
            RemoteExportException ree = new RemoteExportException(4);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (RemoteAuthException rae) {
            rae.setURL(remoteURL);
            throw rae;
        }
        catch (SystemException systemException) {
            RemoteExportException ree = new RemoteExportException(1);
            ree.setURL(remoteURL);
            throw ree;
        }
    }

    protected FileEntry fetchStagingRequestFileEntry(long stagingRequestId, Folder folder) throws PortalException, SystemException {
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry((long)folder.getGroupId(), (long)folder.getFolderId(), (String)this.getAssembledFileName(stagingRequestId));
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            return null;
        }
    }

    protected String getAssembledFileName(long stagingRequestId) {
        return _ASSEMBLED_LAR_PREFIX + String.valueOf(stagingRequestId) + ".lar";
    }

    protected FileEntry getStagingRequestFileEntry(long userId, long stagingRequestId, Folder folder) throws PortalException, SystemException {
        FileEntry fileEntry;
        FileEntry stagingRequestFileEntry = this.fetchStagingRequestFileEntry(stagingRequestId, folder);
        if (stagingRequestFileEntry != null) {
            return stagingRequestFileEntry;
        }
        FileOutputStream fileOutputStream = null;
        File tempFile = null;
        boolean fileMaxSizeCheckEnabled = PortletFileRepositoryThreadLocal.isFileMaxSizeCheckEnabled();
        try {
            PortletFileRepositoryThreadLocal.setFileMaxSizeCheckEnabled((boolean)false);
            tempFile = FileUtil.createTempFile((String)"lar");
            fileOutputStream = new FileOutputStream(tempFile);
            List fileEntries = PortletFileRepositoryUtil.getPortletFileEntries((long)folder.getGroupId(), (long)folder.getFolderId(), (int)-1, (int)-1, (int)-1, (OrderByComparator)new RepositoryModelNameComparator(true));
            for (FileEntry fileEntry2 : fileEntries) {
                InputStream inputStream = fileEntry2.getContentStream();
                try {
                    StreamUtil.transfer((InputStream)inputStream, (OutputStream)fileOutputStream, (boolean)false);
                }
                finally {
                    StreamUtil.cleanUp((InputStream)inputStream);
                    PortletFileRepositoryUtil.deletePortletFileEntry((long)fileEntry2.getFileEntryId());
                }
            }
            String checksum = FileUtil.getMD5Checksum((File)tempFile);
            if (!checksum.equals(folder.getName())) {
                throw new SystemException("Invalid checksum for LAR file");
            }
            PortletFileRepositoryUtil.addPortletFileEntry((long)folder.getGroupId(), (long)userId, (String)Group.class.getName(), (long)folder.getGroupId(), (String)"134", (long)folder.getFolderId(), (File)tempFile, (String)this.getAssembledFileName(stagingRequestId), (String)"application/zip", (boolean)false);
            stagingRequestFileEntry = this.fetchStagingRequestFileEntry(stagingRequestId, folder);
            if (stagingRequestFileEntry == null) {
                throw new SystemException("Unable to assemble LAR file");
            }
            fileEntry = stagingRequestFileEntry;
        }
        catch (IOException ioe) {
            try {
                throw new SystemException("Unable to reassemble LAR file", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(fileOutputStream);
                FileUtil.delete((File)tempFile);
                PortletFileRepositoryThreadLocal.setFileMaxSizeCheckEnabled((boolean)fileMaxSizeCheckEnabled);
                throw throwable;
            }
        }
        StreamUtil.cleanUp((OutputStream)fileOutputStream);
        FileUtil.delete((File)tempFile);
        PortletFileRepositoryThreadLocal.setFileMaxSizeCheckEnabled((boolean)fileMaxSizeCheckEnabled);
        return fileEntry;
    }

    protected void setCommonStagingOptions(Group liveGroup, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) {
        if (liveGroup.getRemoteStagingGroupCount() > 0) {
            return;
        }
        Set parameterNames = serviceContext.getAttributes().keySet();
        for (String parameterName : parameterNames) {
            if (!parameterName.startsWith("staged-portlet_") || parameterName.endsWith("Checkbox")) continue;
            boolean staged = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)parameterName);
            typeSettingsProperties.setProperty(parameterName, String.valueOf(staged));
        }
    }

    protected Layout updateLayoutWithLayoutRevision(LayoutRevision layoutRevision) throws SystemException {
        Layout layout = this.layoutLocalService.fetchLayout(layoutRevision.getPlid());
        LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler((Layout)layout);
        layout = layoutStagingHandler.getLayout();
        layout.setUserId(layoutRevision.getUserId());
        layout.setUserName(layoutRevision.getUserName());
        layout.setCreateDate(layoutRevision.getCreateDate());
        layout.setModifiedDate(layoutRevision.getModifiedDate());
        layout.setPrivateLayout(layoutRevision.getPrivateLayout());
        layout.setName(layoutRevision.getName());
        layout.setTitle(layoutRevision.getTitle());
        layout.setDescription(layoutRevision.getDescription());
        layout.setKeywords(layoutRevision.getKeywords());
        layout.setRobots(layoutRevision.getRobots());
        layout.setTypeSettings(layoutRevision.getTypeSettings());
        layout.setIconImageId(layoutRevision.getIconImageId());
        layout.setThemeId(layoutRevision.getThemeId());
        layout.setColorSchemeId(layoutRevision.getColorSchemeId());
        layout.setWapThemeId(layoutRevision.getWapThemeId());
        layout.setWapColorSchemeId(layoutRevision.getWapColorSchemeId());
        layout.setCss(layoutRevision.getCss());
        return this.layoutLocalService.updateLayout(layout);
    }

    protected void updateStagedPortlets(String remoteURL, long remoteGroupId, UnicodeProperties typeSettingsProperties) throws PortalException {
        RemoteExportException ree;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getScreenName(), user.getPassword(), user.getPasswordEncrypted());
        HashMap<String, String> stagedPortletIds = new HashMap<String, String>();
        for (String key : typeSettingsProperties.keySet()) {
            if (!key.startsWith("staged-portlet_")) continue;
            stagedPortletIds.put(key, typeSettingsProperties.getProperty(key));
        }
        try {
            GroupServiceHttp.updateStagedPortlets(httpPrincipal, remoteGroupId, stagedPortletIds);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ree = new RemoteExportException(2);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (PrincipalException principalException) {
            ree = new RemoteExportException(4);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (RemoteAuthException rae) {
            rae.setURL(remoteURL);
            throw rae;
        }
        catch (SystemException systemException) {
            ree = new RemoteExportException(1);
            ree.setURL(remoteURL);
            throw ree;
        }
    }
}

