/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.concurrent.ConcurrentHashSet;
import com.liferay.portal.kernel.servlet.ServletVersionDetector;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.servlet.SharedSessionAttributeCache;
import com.liferay.portal.util.PropsValues;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SharedSessionAttributeListener
implements HttpSessionAttributeListener,
HttpSessionListener {
    private Set<String> _sessionIds;

    public SharedSessionAttributeListener() {
        if (ServletVersionDetector.is2_5()) {
            return;
        }
        this._sessionIds = new ConcurrentHashSet();
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        if (PropsValues.SESSION_DISABLED || ServletVersionDetector.is2_5()) {
            return;
        }
        HttpSession session = event.getSession();
        if (!this._sessionIds.contains(session.getId())) {
            return;
        }
        SharedSessionAttributeCache sharedSessionAttributeCache = SharedSessionAttributeCache.getInstance(session);
        String name = event.getName();
        if (ArrayUtil.contains((Object[])PropsValues.SESSION_SHARED_ATTRIBUTES_EXCLUDES, (Object)name)) {
            return;
        }
        String[] stringArray = PropsValues.SESSION_SHARED_ATTRIBUTES;
        int n = PropsValues.SESSION_SHARED_ATTRIBUTES.length;
        int n2 = 0;
        while (n2 < n) {
            String sharedName = stringArray[n2];
            if (name.startsWith(sharedName)) {
                sharedSessionAttributeCache.setAttribute(name, event.getValue());
                return;
            }
            ++n2;
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        if (PropsValues.SESSION_DISABLED || ServletVersionDetector.is2_5()) {
            return;
        }
        HttpSession session = event.getSession();
        if (!this._sessionIds.contains(session.getId())) {
            return;
        }
        SharedSessionAttributeCache sharedSessionAttributeCache = SharedSessionAttributeCache.getInstance(session);
        sharedSessionAttributeCache.removeAttribute(event.getName());
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        if (PropsValues.SESSION_DISABLED || ServletVersionDetector.is2_5()) {
            return;
        }
        HttpSession session = event.getSession();
        if (!this._sessionIds.contains(session.getId())) {
            return;
        }
        SharedSessionAttributeCache sharedSessionAttributeCache = SharedSessionAttributeCache.getInstance(session);
        if (sharedSessionAttributeCache.contains(event.getName())) {
            Object value = session.getAttribute(event.getName());
            sharedSessionAttributeCache.setAttribute(event.getName(), value);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (PropsValues.SESSION_DISABLED || ServletVersionDetector.is2_5()) {
            return;
        }
        HttpSession session = event.getSession();
        SharedSessionAttributeCache.getInstance(session);
        this._sessionIds.add(session.getId());
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (PropsValues.SESSION_DISABLED || ServletVersionDetector.is2_5()) {
            return;
        }
        HttpSession session = event.getSession();
        this._sessionIds.remove(session.getId());
    }
}

