/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.List;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class TransactionAttributeBuilder {
    public static TransactionAttribute build(boolean enabled, Isolation isolation, Propagation propagation, boolean readOnly, int timeout, Class<?>[] rollbackForClasses, String[] rollbackForClassNames, Class<?>[] noRollbackForClasses, String[] noRollbackForClassNames) {
        NoRollbackRuleAttribute noRollbackRuleAttribute;
        RollbackRuleAttribute rollbackRuleAttribute;
        if (!enabled) {
            return null;
        }
        RuleBasedTransactionAttribute ruleBasedTransactionAttribute = new RuleBasedTransactionAttribute();
        if (isolation.value() == -3) {
            ruleBasedTransactionAttribute.setIsolationLevel(PropsValues.TRANSACTION_ISOLATION_COUNTER);
        } else if (isolation.value() == -2) {
            ruleBasedTransactionAttribute.setIsolationLevel(PropsValues.TRANSACTION_ISOLATION_PORTAL);
        } else {
            ruleBasedTransactionAttribute.setIsolationLevel(isolation.value());
        }
        ruleBasedTransactionAttribute.setPropagationBehavior(propagation.value());
        ruleBasedTransactionAttribute.setReadOnly(readOnly);
        ruleBasedTransactionAttribute.setTimeout(timeout);
        ArrayList<Object> rollbackRuleAttributes = new ArrayList<Object>();
        int i2 = 0;
        while (i2 < rollbackForClasses.length) {
            rollbackRuleAttribute = new RollbackRuleAttribute(rollbackForClasses[i2]);
            rollbackRuleAttributes.add(rollbackRuleAttribute);
            ++i2;
        }
        i2 = 0;
        while (i2 < rollbackForClassNames.length) {
            rollbackRuleAttribute = new RollbackRuleAttribute(rollbackForClassNames[i2]);
            rollbackRuleAttributes.add(rollbackRuleAttribute);
            ++i2;
        }
        i2 = 0;
        while (i2 < noRollbackForClasses.length) {
            noRollbackRuleAttribute = new NoRollbackRuleAttribute(noRollbackForClasses[i2]);
            rollbackRuleAttributes.add(noRollbackRuleAttribute);
            ++i2;
        }
        i2 = 0;
        while (i2 < noRollbackForClassNames.length) {
            noRollbackRuleAttribute = new NoRollbackRuleAttribute(noRollbackForClassNames[i2]);
            rollbackRuleAttributes.add(noRollbackRuleAttribute);
            ++i2;
        }
        List ruleBasedRollbackRuleAttributes = ruleBasedTransactionAttribute.getRollbackRules();
        ruleBasedRollbackRuleAttributes.addAll(rollbackRuleAttributes);
        return ruleBasedTransactionAttribute;
    }

    public static TransactionAttribute build(Propagation propagation, Class<?>[] rollbackForClasses, Class<?> ... noRollbackForClasses) {
        return TransactionAttributeBuilder.build(true, Isolation.PORTAL, propagation, false, -1, rollbackForClasses, new String[0], noRollbackForClasses, new String[0]);
    }

    public static TransactionAttribute build(Transactional transactional) {
        if (transactional == null) {
            return null;
        }
        return TransactionAttributeBuilder.build(transactional.enabled(), transactional.isolation(), transactional.propagation(), transactional.readOnly(), transactional.timeout(), transactional.rollbackFor(), transactional.rollbackForClassName(), transactional.noRollbackFor(), transactional.noRollbackForClassName());
    }
}

