/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

class TransactionCommitCallbackUtil {
    private static ThreadLocal<List<List<Callable<?>>>> _callbackListListThreadLocal = new AutoResetThreadLocal<List<List<Callable<?>>>>(TransactionCommitCallbackUtil.class + "._callbackListListThreadLocal"){

        protected List<List<Callable<?>>> initialValue() {
            return new ArrayList();
        }
    };

    TransactionCommitCallbackUtil() {
    }

    public static void registerCallback(Callable<?> callable) {
        List<List<Callable<?>>> callbackListList = _callbackListListThreadLocal.get();
        if (callbackListList.isEmpty()) {
            try {
                callable.call();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        } else {
            int index = callbackListList.size() - 1;
            List<Callable<?>> callableList = callbackListList.get(index);
            if (callableList == Collections.emptyList()) {
                callableList = new ArrayList();
                callbackListList.set(index, callableList);
            }
            callableList.add(callable);
        }
    }

    protected static List<Callable<?>> popCallbackList() {
        List<List<Callable<?>>> callbackListList = _callbackListListThreadLocal.get();
        return callbackListList.remove(callbackListList.size() - 1);
    }

    protected static void pushCallbackList() {
        List<List<Callable<?>>> callbackListList = _callbackListListThreadLocal.get();
        callbackListList.add(Collections.emptyList());
    }
}

