/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class UpgradeProcessUtil {
    private static Log _log = LogFactoryUtil.getLog(UpgradeProcessUtil.class);
    private static boolean _createIGImageDocumentType = false;
    private static Map<Long, String> _languageIds = new HashMap<Long, String>();

    public static String getDefaultLanguageId(long companyId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block4: {
            String string;
            String languageId = _languageIds.get(companyId);
            if (languageId != null) {
                return languageId;
            }
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select languageId from User_ where companyId = ? and defaultUser = ?");
                ps.setLong(1, companyId);
                ps.setBoolean(2, true);
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                languageId = rs.getString("languageId");
                _languageIds.put(companyId, languageId);
                string = languageId;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return string;
        }
        String string = LocaleUtil.toLanguageId((Locale)LocaleUtil.US);
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return string;
    }

    public static boolean isCreateIGImageDocumentType() {
        return _createIGImageDocumentType;
    }

    public static void setCreateIGImageDocumentType(boolean createIGImageDocumentType) {
        _createIGImageDocumentType = createIGImageDocumentType;
    }

    public static boolean upgradeProcess(int buildNumber, String[] upgradeProcessClassNames, ClassLoader classLoader) throws UpgradeException {
        return UpgradeProcessUtil.upgradeProcess(buildNumber, upgradeProcessClassNames, classLoader, PropsValues.INDEX_ON_UPGRADE);
    }

    public static boolean upgradeProcess(int buildNumber, String[] upgradeProcessClassNames, ClassLoader classLoader, boolean indexOnUpgrade) throws UpgradeException {
        boolean ranUpgradeProcess = false;
        boolean tempIndexReadOnly = SearchEngineUtil.isIndexReadOnly();
        if (indexOnUpgrade) {
            SearchEngineUtil.setIndexReadOnly((boolean)true);
        }
        try {
            String[] stringArray = upgradeProcessClassNames;
            int n = upgradeProcessClassNames.length;
            int n2 = 0;
            while (n2 < n) {
                String upgradeProcessClassName = stringArray[n2];
                boolean tempRanUpgradeProcess = UpgradeProcessUtil._upgradeProcess(buildNumber, upgradeProcessClassName, classLoader);
                if (tempRanUpgradeProcess) {
                    ranUpgradeProcess = true;
                }
                ++n2;
            }
        }
        finally {
            SearchEngineUtil.setIndexReadOnly((boolean)tempIndexReadOnly);
        }
        return ranUpgradeProcess;
    }

    private static boolean _upgradeProcess(int buildNumber, String upgradeProcessClassName, ClassLoader classLoader) throws UpgradeException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Initializing upgrade " + upgradeProcessClassName));
        }
        UpgradeProcess upgradeProcess = null;
        try {
            Class<?> clazz = classLoader.loadClass(upgradeProcessClassName);
            upgradeProcess = (UpgradeProcess)clazz.newInstance();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        if (upgradeProcess == null) {
            _log.error((Object)(String.valueOf(upgradeProcessClassName) + " cannot be found"));
            return false;
        }
        if (upgradeProcess.getThreshold() == 0 || upgradeProcess.getThreshold() > buildNumber) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Running upgrade " + upgradeProcessClassName));
            }
            upgradeProcess.upgrade();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Finished upgrade " + upgradeProcessClassName));
            }
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Upgrade threshold " + upgradeProcess.getThreshold() + " will not trigger upgrade"));
            _log.debug((Object)("Skipping upgrade " + upgradeProcessClassName));
        }
        return false;
    }
}

