/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.template.BaseTemplateManager;
import com.liferay.portal.template.RestrictedTemplate;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.velocity.FastExtendedProperties;
import com.liferay.portal.velocity.LiferayMethodExceptionEventHandler;
import com.liferay.portal.velocity.LiferayResourceLoader;
import com.liferay.portal.velocity.LiferayResourceManager;
import com.liferay.portal.velocity.VelocityTemplate;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.util.introspection.SecureUberspector;

@DoPrivileged
public class VelocityManager
extends BaseTemplateManager {
    private VelocityEngine _velocityEngine;

    public void destroy() {
        if (this._velocityEngine == null) {
            return;
        }
        this._velocityEngine = null;
        this.templateContextHelper.removeAllHelperUtilities();
        this.templateContextHelper = null;
    }

    public void destroy(ClassLoader classLoader) {
        this.templateContextHelper.removeHelperUtilities(classLoader);
    }

    public String getName() {
        return "vm";
    }

    public void init() throws TemplateException {
        if (this._velocityEngine != null) {
            return;
        }
        this._velocityEngine = new VelocityEngine();
        FastExtendedProperties extendedProperties = new FastExtendedProperties();
        extendedProperties.setProperty("directive.if.tostring.nullcheck", String.valueOf(PropsValues.VELOCITY_ENGINE_DIRECTIVE_IF_TO_STRING_NULL_CHECK));
        extendedProperties.setProperty("eventhandler.methodexception.class", LiferayMethodExceptionEventHandler.class.getName());
        extendedProperties.setProperty("introspector.restrict.classes", StringUtil.merge((Object[])PropsValues.VELOCITY_ENGINE_RESTRICTED_CLASSES));
        extendedProperties.setProperty("introspector.restrict.packages", StringUtil.merge((Object[])PropsValues.VELOCITY_ENGINE_RESTRICTED_PACKAGES));
        extendedProperties.setProperty("resource.loader", "liferay");
        boolean cacheEnabled = false;
        if (PropsValues.VELOCITY_ENGINE_RESOURCE_MODIFICATION_CHECK_INTERVAL != 0) {
            cacheEnabled = true;
        }
        extendedProperties.setProperty("liferay.resource.loader.cache", String.valueOf(cacheEnabled));
        extendedProperties.setProperty("liferay.resource.loader.class", LiferayResourceLoader.class.getName());
        extendedProperties.setProperty("resource.manager.class", LiferayResourceManager.class.getName());
        extendedProperties.setProperty("runtime.log.logsystem.class", PropsUtil.get("velocity.engine.logger"));
        extendedProperties.setProperty("runtime.log.logsystem.log4j.category", PropsUtil.get("velocity.engine.logger.category"));
        extendedProperties.setProperty("runtime.introspector.uberspect", SecureUberspector.class.getName());
        extendedProperties.setProperty("velocimacro.library", PropsUtil.get("velocity.engine.velocimacro.library"));
        extendedProperties.setProperty("velocimacro.library.autoreload", String.valueOf(!cacheEnabled));
        extendedProperties.setProperty("velocimacro.permissions.allow.inline.to.replace.global", String.valueOf(!cacheEnabled));
        this._velocityEngine.setExtendedProperties((ExtendedProperties)extendedProperties);
        try {
            this._velocityEngine.init();
        }
        catch (Exception e2) {
            throw new TemplateException((Throwable)e2);
        }
    }

    @Override
    protected Template doGetTemplate(TemplateResource templateResource, TemplateResource errorTemplateResource, boolean restricted, Map<String, Object> helperUtilities, boolean privileged) {
        Object template = new VelocityTemplate(templateResource, errorTemplateResource, helperUtilities, this._velocityEngine, this.templateContextHelper, privileged);
        if (restricted) {
            template = new RestrictedTemplate((Template)template, this.templateContextHelper.getRestrictedVariables());
        }
        return template;
    }
}

