/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.cal.TZSRecurrence;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.CalEventLocalServiceUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.jabsorb.JSONSerializer;

public class VerifyCalendar
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyCalendar.class);

    @Override
    protected void doVerify() throws Exception {
        this.verifyEndDate();
        this.verifyNoAssets();
        this.verifyRecurrence();
    }

    protected void updateEvent(long eventId, String recurrence) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update CalEvent set recurrence = ? where eventId = ?");
            ps.setString(1, recurrence);
            ps.setLong(2, eventId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void verifyEndDate() throws Exception {
        this.runSQL("update CalEvent set endDate = null where endDate is not null and (recurrence like '%\"until\":null%' or recurrence like 'null')");
    }

    protected void verifyNoAssets() throws Exception {
        List events = CalEventLocalServiceUtil.getNoAssetEvents();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + events.size() + " events with no asset"));
        }
        for (CalEvent event : events) {
            try {
                CalEventLocalServiceUtil.updateAsset((long)event.getUserId(), (CalEvent)event, null, null, null);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for event " + event.getEventId() + ": " + e2.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for events");
        }
    }

    protected void verifyRecurrence() throws Exception {
        JSONSerializer jsonSerializer = new JSONSerializer();
        jsonSerializer.registerDefaultSerializers();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select eventId, recurrence from CalEvent where (CAST_TEXT(recurrence) != '') and recurrence not like '%serializable%'");
            rs = ps.executeQuery();
            while (rs.next()) {
                long eventId = rs.getLong("eventId");
                String recurrence = rs.getString("recurrence");
                TZSRecurrence recurrenceObj = null;
                if (Validator.isNotNull((String)recurrence)) {
                    recurrenceObj = (TZSRecurrence)jsonSerializer.fromJSON(recurrence);
                }
                String newRecurrence = JSONFactoryUtil.serialize(recurrenceObj);
                this.updateEvent(eventId, newRecurrence);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

