/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;

public class BlogsEntryPermission {
    public static void check(PermissionChecker permissionChecker, BlogsEntry entry, String actionId) throws PortalException {
        if (!BlogsEntryPermission.contains(permissionChecker, entry, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException, SystemException {
        if (!BlogsEntryPermission.contains(permissionChecker, entryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, BlogsEntry entry, String actionId) {
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)entry.getGroupId(), (String)BlogsEntry.class.getName(), (long)entry.getEntryId(), (String)"33", (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (entry.isDraft() || entry.isScheduled()) {
            if (actionId.equals("VIEW") && !BlogsEntryPermission.contains(permissionChecker, entry, "UPDATE")) {
                return false;
            }
        } else if (entry.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)entry.getGroupId(), (String)BlogsEntry.class.getName(), (long)entry.getEntryId(), (String)actionId)) != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(entry.getCompanyId(), BlogsEntry.class.getName(), entry.getEntryId(), entry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException, SystemException {
        BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)entryId);
        return BlogsEntryPermission.contains(permissionChecker, entry, actionId);
    }
}

