/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.JournalFeedServiceUtil;
import com.liferay.portlet.journal.service.JournalFolderServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import com.liferay.portlet.journal.util.JournalConverterUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ActionUtil {
    public static void deleteArticle(ActionRequest actionRequest, String deleteArticleId) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String articleId = deleteArticleId;
        String articleURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleURL");
        double version = 0.0;
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        int pos = deleteArticleId.lastIndexOf("_version_");
        if (pos == -1) {
            JournalArticleServiceUtil.deleteArticle((long)groupId, (String)articleId, (String)articleURL, (ServiceContext)serviceContext);
        } else {
            articleId = articleId.substring(0, pos);
            version = GetterUtil.getDouble((String)deleteArticleId.substring(pos + "_version_".length()));
            JournalArticleServiceUtil.deleteArticle((long)groupId, (String)articleId, (double)version, (String)articleURL, (ServiceContext)serviceContext);
        }
        JournalUtil.removeRecentArticle((PortletRequest)actionRequest, articleId, version);
    }

    public static void expireArticle(ActionRequest actionRequest, String expireArticleId) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String articleId = expireArticleId;
        String articleURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleURL");
        double version = 0.0;
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        int pos = expireArticleId.lastIndexOf("_version_");
        if (pos == -1) {
            JournalArticleServiceUtil.expireArticle((long)groupId, (String)articleId, (String)articleURL, (ServiceContext)serviceContext);
        } else {
            articleId = articleId.substring(0, pos);
            version = GetterUtil.getDouble((String)expireArticleId.substring(pos + "_version_".length()));
            JournalArticleServiceUtil.expireArticle((long)groupId, (String)articleId, (double)version, (String)articleURL, (ServiceContext)serviceContext);
        }
        JournalUtil.removeRecentArticle((PortletRequest)actionRequest, articleId, version);
    }

    public static void expireFolder(long groupId, long parentFolderId, ServiceContext serviceContext) throws Exception {
        List folders = JournalFolderServiceUtil.getFolders((long)groupId, (long)parentFolderId);
        for (JournalFolder folder : folders) {
            ActionUtil.expireFolder(groupId, folder.getFolderId(), serviceContext);
        }
        List articles = JournalArticleServiceUtil.getArticles((long)groupId, (long)parentFolderId);
        for (JournalArticle article : articles) {
            JournalArticleServiceUtil.expireArticle((long)groupId, (String)article.getArticleId(), null, (ServiceContext)serviceContext);
        }
    }

    public static void getArticle(HttpServletRequest request) throws Exception {
        String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long resourcePrimKey = ParamUtil.getLong((HttpServletRequest)request, (String)"resourcePrimKey");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId", (long)themeDisplay.getScopeGroupId());
        long classNameId = ParamUtil.getLong((HttpServletRequest)request, (String)"classNameId");
        long classPK = ParamUtil.getLong((HttpServletRequest)request, (String)"classPK");
        String articleId = ParamUtil.getString((HttpServletRequest)request, (String)"articleId");
        String structureId = ParamUtil.getString((HttpServletRequest)request, (String)"structureId");
        int status = ParamUtil.getInteger((HttpServletRequest)request, (String)"status", (int)-1);
        JournalArticle article = null;
        if (cmd.equals("add") && resourcePrimKey != 0L) {
            article = JournalArticleLocalServiceUtil.getLatestArticle((long)resourcePrimKey, (int)status, (boolean)false);
        } else if (!cmd.equals("add") && Validator.isNotNull((String)articleId)) {
            article = JournalArticleServiceUtil.getLatestArticle((long)groupId, (String)articleId, (int)status);
        } else if (classNameId > 0L && classPK > 0L) {
            String className = PortalUtil.getClassName((long)classNameId);
            article = JournalArticleServiceUtil.getLatestArticle((long)groupId, (String)className, (long)classPK);
        } else if (Validator.isNotNull((String)structureId)) {
            DDMStructure ddmStructure = DDMStructureServiceUtil.fetchStructure((long)groupId, (long)PortalUtil.getClassNameId(JournalArticle.class), (String)structureId, (boolean)true);
            if (ddmStructure == null) {
                return;
            }
            article = JournalArticleServiceUtil.getArticle((long)ddmStructure.getGroupId(), (String)DDMStructure.class.getName(), (long)ddmStructure.getStructureId());
            article.setNew(true);
            article.setId(0L);
            article.setGroupId(groupId);
            article.setClassNameId(0L);
            article.setClassPK(0L);
            article.setArticleId(null);
            article.setVersion(0.0);
        }
        request.setAttribute("JOURNAL_ARTICLE", (Object)article);
    }

    public static void getArticle(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getArticle(request);
        JournalArticle article = (JournalArticle)portletRequest.getAttribute("JOURNAL_ARTICLE");
        JournalUtil.addRecentArticle(portletRequest, article);
    }

    public static void getArticles(HttpServletRequest request) throws Exception {
        String[] articleIds;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ArrayList<JournalArticle> articles = new ArrayList<JournalArticle>();
        String[] stringArray = articleIds = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)request, (String)"articleIds"));
        int n = articleIds.length;
        int n2 = 0;
        while (n2 < n) {
            String articleId = stringArray[n2];
            JournalArticle article = JournalArticleServiceUtil.fetchArticle((long)themeDisplay.getScopeGroupId(), (String)articleId);
            if (article != null) {
                articles.add(article);
            }
            ++n2;
        }
        request.setAttribute("JOURNAL_ARTICLES", articles);
    }

    public static void getArticles(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getArticles(request);
    }

    public static Object[] getContentAndImages(DDMStructure ddmStructure, Locale locale, ServiceContext serviceContext) throws Exception {
        Fields fields = DDMUtil.getFields((long)ddmStructure.getStructureId(), (ServiceContext)serviceContext);
        Map<String, byte[]> images = ActionUtil.getImages(fields, locale);
        return new Object[]{JournalConverterUtil.getContent((DDMStructure)ddmStructure, (Fields)fields), images};
    }

    public static void getFeed(HttpServletRequest request) throws Exception {
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        String feedId = ParamUtil.getString((HttpServletRequest)request, (String)"feedId");
        JournalFeed feed = null;
        if (Validator.isNotNull((String)feedId)) {
            feed = JournalFeedServiceUtil.getFeed((long)groupId, (String)feedId);
        }
        request.setAttribute("JOURNAL_FEED", (Object)feed);
    }

    public static void getFeed(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getFeed(request);
    }

    public static void getFolder(HttpServletRequest request) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((HttpServletRequest)request, (String)"folderId");
        JournalFolder folder = null;
        if (folderId > 0L && folderId != 0L) {
            folder = JournalFolderServiceUtil.getFolder((long)folderId);
        } else {
            JournalPermission.check(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "VIEW");
        }
        request.setAttribute("JOURNAL_FOLDER", (Object)folder);
    }

    public static void getFolder(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getFolder(request);
    }

    public static void getFolders(HttpServletRequest request) throws Exception {
        long[] folderIds = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)request, (String)"folderIds"), (long)0L);
        ArrayList<JournalFolder> folders = new ArrayList<JournalFolder>();
        long[] lArray = folderIds;
        int n = folderIds.length;
        int n2 = 0;
        while (n2 < n) {
            long folderId = lArray[n2];
            JournalFolder folder = JournalFolderServiceUtil.fetchFolder((long)folderId);
            if (folder != null) {
                folders.add(folder);
            }
            ++n2;
        }
        request.setAttribute("JOURNAL_FOLDERS", folders);
    }

    public static void getFolders(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getFolders(request);
    }

    public static void getStructure(HttpServletRequest request) throws Exception {
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        long classNameId = ParamUtil.getLong((HttpServletRequest)request, (String)"classNameId");
        String structureId = ParamUtil.getString((HttpServletRequest)request, (String)"structureId");
        DDMStructure ddmStructure = null;
        if (Validator.isNotNull((String)structureId)) {
            ddmStructure = DDMStructureServiceUtil.getStructure((long)groupId, (long)classNameId, (String)structureId);
        }
        request.setAttribute("JOURNAL_STRUCTURE", ddmStructure);
    }

    public static void getStructure(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getStructure(request);
        DDMStructure ddmStructure = (DDMStructure)portletRequest.getAttribute("JOURNAL_STRUCTURE");
        JournalUtil.addRecentDDMStructure(portletRequest, ddmStructure);
    }

    public static void getTemplate(HttpServletRequest request) throws Exception {
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        String templateId = ParamUtil.getString((HttpServletRequest)request, (String)"templateId");
        DDMTemplate ddmTemplate = null;
        if (Validator.isNotNull((String)templateId)) {
            ddmTemplate = DDMTemplateServiceUtil.getTemplate((long)groupId, (long)PortalUtil.getClassNameId(DDMStructure.class), (String)templateId, (boolean)true);
        }
        request.setAttribute("JOURNAL_TEMPLATE", ddmTemplate);
    }

    public static void getTemplate(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getTemplate(request);
        DDMTemplate ddmTemplate = (DDMTemplate)portletRequest.getAttribute("JOURNAL_TEMPLATE");
        JournalUtil.addRecentDDMTemplate(portletRequest, ddmTemplate);
    }

    protected static Map<String, byte[]> getImages(Fields fields, Locale locale) throws Exception {
        HashMap<String, byte[]> images = new HashMap<String, byte[]>();
        for (Field field : fields) {
            String dataType = field.getDataType();
            if (!dataType.equals("image")) continue;
            List values = field.getValues(locale);
            int i2 = 0;
            while (i2 < values.size()) {
                StringBundler sb = new StringBundler(6);
                sb.append("_");
                sb.append(field.getName());
                sb.append("_");
                sb.append(i2);
                sb.append("_");
                sb.append(LanguageUtil.getLanguageId((Locale)locale));
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)((String)values.get(i2)));
                String content = jsonObject.getString("data");
                images.put(sb.toString(), UnicodeFormatter.hexToBytes((String)content));
                ++i2;
            }
        }
        return images;
    }

    protected static boolean hasArticle(ActionRequest actionRequest) throws Exception {
        JournalArticle article;
        int pos;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        if (Validator.isNull((String)articleId)) {
            String[] articleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"articleIds"));
            if (articleIds.length <= 0) {
                return false;
            }
            articleId = articleIds[0];
        }
        if ((pos = articleId.lastIndexOf("_version_")) != -1) {
            articleId = articleId.substring(0, pos);
        }
        return (article = JournalArticleLocalServiceUtil.fetchArticle((long)themeDisplay.getScopeGroupId(), (String)articleId)) != null;
    }
}

