/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.templateparser.BaseTransformerListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesTransformerListener
extends BaseTransformerListener {
    private static final String _GLOBAL_PROPERTIES = "GLOBAL-PROPERTIES";
    private static Log _log = LogFactoryUtil.getLog(PropertiesTransformerListener.class);

    public String onOutput(String output, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onOutput");
        }
        return this.replace(output, languageId, tokens);
    }

    public String onScript(String script, String xml, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onScript");
        }
        return this.replace(script, languageId, tokens);
    }

    protected String replace(String s, String languageId, Map<String, String> tokens) {
        Properties properties;
        block5: {
            String templateId = tokens.get("template_id");
            if (templateId == null || templateId != null && templateId.equals(_GLOBAL_PROPERTIES)) {
                return s;
            }
            properties = new Properties();
            try {
                HashMap<String, String> newTokens = new HashMap<String, String>();
                MapUtil.copy(tokens, newTokens);
                newTokens.put("template_id", _GLOBAL_PROPERTIES);
                long articleGroupId = GetterUtil.getLong((String)tokens.get("article_group_id"));
                String script = JournalUtil.getTemplateScript(articleGroupId, _GLOBAL_PROPERTIES, newTokens, languageId);
                PropertiesUtil.load((Properties)properties, (String)script);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Throwable)e2);
            }
        }
        if (properties.isEmpty()) {
            return s;
        }
        String[] escapedKeys = new String[properties.size()];
        String[] escapedValues = new String[properties.size()];
        String[] keys = new String[properties.size()];
        String[] values = new String[properties.size()];
        String[] tempEscapedKeys = new String[properties.size()];
        String[] tempEscapedValues = new String[properties.size()];
        int counter = 0;
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String escapedKey = "@@" + key + "@" + "@";
            String actualKey = "@" + key + "@";
            String tempEscapedKey = "[$TEMP_ESCAPED_AT_OPEN$]" + key + "[$_TEMP_ESCAPED_AT_CLOSE$]";
            escapedKeys[counter] = escapedKey;
            escapedValues[counter] = tempEscapedKey;
            keys[counter] = actualKey;
            values[counter] = value;
            tempEscapedKeys[counter] = tempEscapedKey;
            tempEscapedValues[counter] = actualKey;
            ++counter;
        }
        s = StringUtil.replace((String)s, (String[])escapedKeys, (String[])escapedValues);
        s = StringUtil.replace((String)s, (String[])keys, (String[])values);
        s = StringUtil.replace((String)s, (String[])tempEscapedKeys, (String[])tempEscapedValues);
        return s;
    }
}

