/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.core.config;

import java.util.HashMap;
import org.apache.lucene.queryParser.core.config.ConfigAttribute;
import org.apache.lucene.queryParser.core.config.ConfigurationKey;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryConfig
extends AttributeSource {
    private final HashMap<ConfigurationKey<?>, Object> configMap = new HashMap();

    AbstractQueryConfig() {
    }

    public <T> T get(ConfigurationKey<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null!");
        }
        return (T)this.configMap.get(key);
    }

    public <T> T get(ConfigurationKey<T> key, T defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null!");
        }
        if (this.configMap.containsKey(key)) {
            return (T)this.configMap.get(key);
        }
        return defaultValue;
    }

    public <T> boolean has(ConfigurationKey<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null!");
        }
        return this.configMap.containsKey(key);
    }

    public <T> void set(ConfigurationKey<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null!");
        }
        if (value == null) {
            this.unset(key);
        } else {
            this.configMap.put(key, value);
        }
    }

    public <A extends Attribute> A addAttribute(Class<A> attClass) {
        if (this.hasAttribute(attClass)) {
            return (A)this.getAttribute(attClass);
        }
        Attribute attr = super.addAttribute(attClass);
        if (attr instanceof ConfigAttribute) {
            ((ConfigAttribute)attr).setQueryConfigHandler(this);
        }
        return (A)attr;
    }

    public <T> boolean unset(ConfigurationKey<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null!");
        }
        return this.configMap.remove(key) != null;
    }
}

