/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard.config;

import java.text.Collator;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.queryParser.core.config.ConfigurationKey;
import org.apache.lucene.queryParser.core.config.QueryConfigHandler;
import org.apache.lucene.queryParser.standard.config.AllowLeadingWildcardAttribute;
import org.apache.lucene.queryParser.standard.config.AnalyzerAttribute;
import org.apache.lucene.queryParser.standard.config.DefaultOperatorAttribute;
import org.apache.lucene.queryParser.standard.config.DefaultPhraseSlopAttribute;
import org.apache.lucene.queryParser.standard.config.FieldBoostMapAttribute;
import org.apache.lucene.queryParser.standard.config.FieldBoostMapFCListener;
import org.apache.lucene.queryParser.standard.config.FieldDateResolutionFCListener;
import org.apache.lucene.queryParser.standard.config.FuzzyAttribute;
import org.apache.lucene.queryParser.standard.config.FuzzyConfig;
import org.apache.lucene.queryParser.standard.config.LocaleAttribute;
import org.apache.lucene.queryParser.standard.config.LowercaseExpandedTermsAttribute;
import org.apache.lucene.queryParser.standard.config.MultiTermRewriteMethodAttribute;
import org.apache.lucene.queryParser.standard.config.NumericConfig;
import org.apache.lucene.queryParser.standard.config.NumericFieldConfigListener;
import org.apache.lucene.queryParser.standard.config.PositionIncrementsAttribute;
import org.apache.lucene.queryParser.standard.config.RangeCollatorAttribute;
import org.apache.lucene.search.MultiTermQuery;

public class StandardQueryConfigHandler
extends QueryConfigHandler {
    public StandardQueryConfigHandler() {
        this.addFieldConfigListener(new FieldBoostMapFCListener(this));
        this.addFieldConfigListener(new FieldDateResolutionFCListener(this));
        this.addFieldConfigListener(new NumericFieldConfigListener(this));
        this.addAttribute(RangeCollatorAttribute.class);
        this.addAttribute(DefaultOperatorAttribute.class);
        this.addAttribute(AnalyzerAttribute.class);
        this.addAttribute(FuzzyAttribute.class);
        this.addAttribute(LowercaseExpandedTermsAttribute.class);
        this.addAttribute(MultiTermRewriteMethodAttribute.class);
        this.addAttribute(AllowLeadingWildcardAttribute.class);
        this.addAttribute(PositionIncrementsAttribute.class);
        this.addAttribute(LocaleAttribute.class);
        this.addAttribute(DefaultPhraseSlopAttribute.class);
        this.addAttribute(MultiTermRewriteMethodAttribute.class);
        this.addAttribute(FieldBoostMapAttribute.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        AND,
        OR;

    }

    public static final class ConfigurationKeys {
        public static final ConfigurationKey<Boolean> ENABLE_POSITION_INCREMENTS = ConfigurationKey.newInstance();
        public static final ConfigurationKey<Boolean> LOWERCASE_EXPANDED_TERMS = ConfigurationKey.newInstance();
        public static final ConfigurationKey<Boolean> ALLOW_LEADING_WILDCARD = ConfigurationKey.newInstance();
        public static final ConfigurationKey<Analyzer> ANALYZER = ConfigurationKey.newInstance();
        public static final ConfigurationKey<Operator> DEFAULT_OPERATOR = ConfigurationKey.newInstance();
        public static final ConfigurationKey<Integer> PHRASE_SLOP = ConfigurationKey.newInstance();
        public static final ConfigurationKey<Locale> LOCALE = ConfigurationKey.newInstance();
        public static final ConfigurationKey<MultiTermQuery.RewriteMethod> MULTI_TERM_REWRITE_METHOD = ConfigurationKey.newInstance();
        public static final ConfigurationKey<CharSequence[]> MULTI_FIELDS = ConfigurationKey.newInstance();
        public static final ConfigurationKey<Map<String, Float>> FIELD_BOOST_MAP = ConfigurationKey.newInstance();
        public static final ConfigurationKey<Map<CharSequence, DateTools.Resolution>> FIELD_DATE_RESOLUTION_MAP = ConfigurationKey.newInstance();
        public static final ConfigurationKey<FuzzyConfig> FUZZY_CONFIG = ConfigurationKey.newInstance();
        public static final ConfigurationKey<DateTools.Resolution> DATE_RESOLUTION = ConfigurationKey.newInstance();
        public static final ConfigurationKey<Float> BOOST = ConfigurationKey.newInstance();
        public static final ConfigurationKey<NumericConfig> NUMERIC_CONFIG = ConfigurationKey.newInstance();
        public static final ConfigurationKey<Map<String, NumericConfig>> NUMERIC_CONFIG_MAP = ConfigurationKey.newInstance();
        public static final ConfigurationKey<Collator> RANGE_COLLATOR = ConfigurationKey.newInstance();
    }
}

