/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.ConfigurationKeys;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.handlers.HandlerUtil;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAST;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import lombok.eclipse.handlers.SetGeneratedByVisitor;
import lombok.experimental.Builder;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleConstructor {
    private static final char[][] JAVA_BEANS_CONSTRUCTORPROPERTIES = new char[][]{"java".toCharArray(), "beans".toCharArray(), "ConstructorProperties".toCharArray()};

    private static List<EclipseNode> findRequiredFields(EclipseNode typeNode) {
        ArrayList<EclipseNode> fields = new ArrayList<EclipseNode>();
        for (EclipseNode child : typeNode.down()) {
            boolean isNonNull;
            FieldDeclaration fieldDecl;
            if (child.getKind() != AST.Kind.FIELD || !EclipseHandlerUtil.filterField(fieldDecl = (FieldDeclaration)child.get())) continue;
            boolean isFinal = (fieldDecl.modifiers & 0x10) != 0;
            boolean bl = isNonNull = Eclipse.findAnnotations(fieldDecl, HandlerUtil.NON_NULL_PATTERN).length != 0;
            if (!isFinal && !isNonNull || fieldDecl.initialization != null) continue;
            fields.add(child);
        }
        return fields;
    }

    static List<EclipseNode> findAllFields(EclipseNode typeNode) {
        ArrayList<EclipseNode> fields = new ArrayList<EclipseNode>();
        for (EclipseNode child : typeNode.down()) {
            FieldDeclaration fieldDecl;
            if (child.getKind() != AST.Kind.FIELD || !EclipseHandlerUtil.filterField(fieldDecl = (FieldDeclaration)child.get()) || (fieldDecl.modifiers & 0x10) != 0 && fieldDecl.initialization != null) continue;
            fields.add(child);
        }
        return fields;
    }

    static boolean checkLegality(EclipseNode typeNode, EclipseNode errorNode, String name) {
        boolean notAClass;
        TypeDeclaration typeDecl = null;
        if (typeNode.get() instanceof TypeDeclaration) {
            typeDecl = (TypeDeclaration)typeNode.get();
        }
        int modifiers = typeDecl == null ? 0 : typeDecl.modifiers;
        boolean bl = notAClass = (modifiers & 0x2200) != 0;
        if (typeDecl == null || notAClass) {
            errorNode.addError(name + " is only supported on a class or an enum.");
            return false;
        }
        return true;
    }

    public void generateRequiredArgsConstructor(EclipseNode typeNode, AccessLevel level, String staticName, SkipIfConstructorExists skipIfConstructorExists, List<Annotation> onConstructor, EclipseNode sourceNode) {
        this.generateConstructor(typeNode, level, HandleConstructor.findRequiredFields(typeNode), staticName, skipIfConstructorExists, null, onConstructor, sourceNode);
    }

    public void generateAllArgsConstructor(EclipseNode typeNode, AccessLevel level, String staticName, SkipIfConstructorExists skipIfConstructorExists, List<Annotation> onConstructor, EclipseNode sourceNode) {
        this.generateConstructor(typeNode, level, HandleConstructor.findAllFields(typeNode), staticName, skipIfConstructorExists, null, onConstructor, sourceNode);
    }

    public void generateConstructor(EclipseNode typeNode, AccessLevel level, List<EclipseNode> fields, String staticName, SkipIfConstructorExists skipIfConstructorExists, Boolean suppressConstructorProperties, List<Annotation> onConstructor, EclipseNode sourceNode) {
        boolean staticConstrRequired;
        ASTNode source = (ASTNode)sourceNode.get();
        boolean bl = staticConstrRequired = staticName != null && !staticName.equals("");
        if (skipIfConstructorExists != SkipIfConstructorExists.NO && EclipseHandlerUtil.constructorExists(typeNode) != EclipseHandlerUtil.MemberExistsResult.NOT_EXISTS) {
            return;
        }
        if (skipIfConstructorExists != SkipIfConstructorExists.NO) {
            for (EclipseNode child : typeNode.down()) {
                boolean skipGeneration;
                if (child.getKind() != AST.Kind.ANNOTATION) continue;
                boolean bl2 = skipGeneration = EclipseHandlerUtil.annotationTypeMatches(NoArgsConstructor.class, child) || EclipseHandlerUtil.annotationTypeMatches(AllArgsConstructor.class, child) || EclipseHandlerUtil.annotationTypeMatches(RequiredArgsConstructor.class, child);
                if (!skipGeneration && skipIfConstructorExists == SkipIfConstructorExists.YES) {
                    skipGeneration = EclipseHandlerUtil.annotationTypeMatches(Builder.class, child);
                }
                if (!skipGeneration) continue;
                if (staticConstrRequired) {
                    typeNode.addWarning("Ignoring static constructor name: explicit @XxxArgsConstructor annotation present; its `staticName` parameter will be used.", source.sourceStart, source.sourceEnd);
                }
                return;
            }
        }
        ConstructorDeclaration constr = HandleConstructor.createConstructor(staticConstrRequired ? AccessLevel.PRIVATE : level, typeNode, fields, suppressConstructorProperties, sourceNode, onConstructor);
        EclipseHandlerUtil.injectMethod(typeNode, (AbstractMethodDeclaration)constr);
        if (staticConstrRequired) {
            MethodDeclaration staticConstr = this.createStaticConstructor(level, staticName, typeNode, fields, source);
            EclipseHandlerUtil.injectMethod(typeNode, (AbstractMethodDeclaration)staticConstr);
        }
    }

    public static Annotation[] createConstructorProperties(ASTNode source, Collection<EclipseNode> fields) {
        if (fields.isEmpty()) {
            return null;
        }
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        long[] poss = new long[3];
        Arrays.fill(poss, p);
        QualifiedTypeReference constructorPropertiesType = new QualifiedTypeReference(JAVA_BEANS_CONSTRUCTORPROPERTIES, poss);
        EclipseHandlerUtil.setGeneratedBy((ASTNode)constructorPropertiesType, source);
        SingleMemberAnnotation ann = new SingleMemberAnnotation((TypeReference)constructorPropertiesType, pS);
        ann.declarationSourceEnd = pE;
        ArrayInitializer fieldNames = new ArrayInitializer();
        fieldNames.sourceStart = pS;
        fieldNames.sourceEnd = pE;
        fieldNames.expressions = new Expression[fields.size()];
        int ctr = 0;
        for (EclipseNode field : fields) {
            char[] fieldName = EclipseHandlerUtil.removePrefixFromField(field);
            fieldNames.expressions[ctr] = new StringLiteral(fieldName, pS, pE, 0);
            EclipseHandlerUtil.setGeneratedBy((ASTNode)fieldNames.expressions[ctr], source);
            ++ctr;
        }
        ann.memberValue = fieldNames;
        EclipseHandlerUtil.setGeneratedBy((ASTNode)ann, source);
        EclipseHandlerUtil.setGeneratedBy((ASTNode)ann.memberValue, source);
        return new Annotation[]{ann};
    }

    public static ConstructorDeclaration createConstructor(AccessLevel level, EclipseNode type, Collection<EclipseNode> fields, Boolean suppressConstructorProperties, EclipseNode sourceNode, List<Annotation> onConstructor) {
        Annotation[] copiedAnnotations;
        boolean isEnum;
        ASTNode source = (ASTNode)sourceNode.get();
        TypeDeclaration typeDeclaration = (TypeDeclaration)type.get();
        long p = (long)source.sourceStart << 32 | (long)source.sourceEnd;
        boolean bl = isEnum = (((TypeDeclaration)type.get()).modifiers & 0x4000) != 0;
        if (isEnum) {
            level = AccessLevel.PRIVATE;
        }
        if (suppressConstructorProperties == null) {
            suppressConstructorProperties = fields.isEmpty() ? Boolean.valueOf(false) : Boolean.valueOf(Boolean.TRUE.equals(((EclipseAST)type.getAst()).readConfiguration(ConfigurationKeys.ANY_CONSTRUCTOR_SUPPRESS_CONSTRUCTOR_PROPERTIES)));
        }
        ConstructorDeclaration constructor = new ConstructorDeclaration(((CompilationUnitDeclaration)((EclipseNode)type.top()).get()).compilationResult);
        constructor.modifiers = EclipseHandlerUtil.toEclipseModifier(level);
        constructor.selector = typeDeclaration.name;
        constructor.constructorCall = new ExplicitConstructorCall(1);
        constructor.constructorCall.sourceStart = source.sourceStart;
        constructor.constructorCall.sourceEnd = source.sourceEnd;
        constructor.thrownExceptions = null;
        constructor.typeParameters = null;
        constructor.bits |= 0x800000;
        constructor.declarationSourceStart = constructor.sourceStart = source.sourceStart;
        constructor.bodyStart = constructor.sourceStart;
        constructor.declarationSourceEnd = constructor.sourceEnd = source.sourceEnd;
        constructor.bodyEnd = constructor.sourceEnd;
        constructor.arguments = null;
        ArrayList<Argument> params = new ArrayList<Argument>();
        ArrayList<Assignment> assigns = new ArrayList<Assignment>();
        ArrayList<Object> nullChecks = new ArrayList<Object>();
        for (EclipseNode fieldNode : fields) {
            Annotation[] copiedAnnotations2;
            Statement nullCheck;
            FieldDeclaration field = (FieldDeclaration)fieldNode.get();
            char[] rawName = field.name;
            char[] fieldName = EclipseHandlerUtil.removePrefixFromField(fieldNode);
            FieldReference thisX = new FieldReference(rawName, p);
            thisX.receiver = new ThisReference((int)(p >> 32), (int)p);
            SingleNameReference assignmentNameRef = new SingleNameReference(fieldName, p);
            Assignment assignment = new Assignment((Expression)thisX, (Expression)assignmentNameRef, (int)p);
            assignment.sourceStart = (int)(p >> 32);
            assignment.sourceEnd = assignment.statementEnd = (int)(p >> 32);
            assigns.add(assignment);
            long fieldPos = (long)field.sourceStart << 32 | (long)field.sourceEnd;
            Argument parameter = new Argument(fieldName, fieldPos, EclipseHandlerUtil.copyType(field.type, source), 16);
            Annotation[] nonNulls = Eclipse.findAnnotations(field, HandlerUtil.NON_NULL_PATTERN);
            Annotation[] nullables = Eclipse.findAnnotations(field, HandlerUtil.NULLABLE_PATTERN);
            if (nonNulls.length != 0 && (nullCheck = EclipseHandlerUtil.generateNullCheck((AbstractVariableDeclaration)field, sourceNode)) != null) {
                nullChecks.add(nullCheck);
            }
            if ((copiedAnnotations2 = EclipseHandlerUtil.copyAnnotations(source, nonNulls, nullables)).length != 0) {
                parameter.annotations = copiedAnnotations2;
            }
            params.add(parameter);
        }
        nullChecks.addAll(assigns);
        constructor.statements = nullChecks.isEmpty() ? null : nullChecks.toArray(new Statement[nullChecks.size()]);
        constructor.arguments = params.isEmpty() ? null : params.toArray(new Argument[params.size()]);
        Annotation[] constructorProperties = null;
        if (!suppressConstructorProperties.booleanValue() && level != AccessLevel.PRIVATE && level != AccessLevel.PACKAGE && !HandleConstructor.isLocalType(type)) {
            constructorProperties = HandleConstructor.createConstructorProperties(source, fields);
        }
        if ((copiedAnnotations = EclipseHandlerUtil.copyAnnotations(source, onConstructor.toArray(new Annotation[0]), constructorProperties)).length != 0) {
            constructor.annotations = copiedAnnotations;
        }
        constructor.traverse((ASTVisitor)new SetGeneratedByVisitor(source), typeDeclaration.scope);
        return constructor;
    }

    public static boolean isLocalType(EclipseNode type) {
        AST.Kind kind = ((EclipseNode)type.up()).getKind();
        if (kind == AST.Kind.COMPILATION_UNIT) {
            return false;
        }
        if (kind == AST.Kind.TYPE) {
            return HandleConstructor.isLocalType((EclipseNode)type.up());
        }
        return true;
    }

    public MethodDeclaration createStaticConstructor(AccessLevel level, String name, EclipseNode type, Collection<EclipseNode> fields, ASTNode source) {
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        MethodDeclaration constructor = new MethodDeclaration(((CompilationUnitDeclaration)((EclipseNode)type.top()).get()).compilationResult);
        constructor.modifiers = EclipseHandlerUtil.toEclipseModifier(level) | 8;
        TypeDeclaration typeDecl = (TypeDeclaration)type.get();
        constructor.returnType = EclipseHandlerUtil.namePlusTypeParamsToTypeReference(typeDecl.name, typeDecl.typeParameters, p);
        constructor.annotations = null;
        constructor.selector = name.toCharArray();
        constructor.thrownExceptions = null;
        constructor.typeParameters = EclipseHandlerUtil.copyTypeParams(((TypeDeclaration)type.get()).typeParameters, source);
        constructor.bits |= 0x800000;
        constructor.declarationSourceStart = constructor.sourceStart = source.sourceStart;
        constructor.bodyStart = constructor.sourceStart;
        constructor.declarationSourceEnd = constructor.sourceEnd = source.sourceEnd;
        constructor.bodyEnd = constructor.sourceEnd;
        ArrayList<Argument> params = new ArrayList<Argument>();
        ArrayList<SingleNameReference> assigns = new ArrayList<SingleNameReference>();
        AllocationExpression statement = new AllocationExpression();
        statement.sourceStart = pS;
        statement.sourceEnd = pE;
        statement.type = EclipseHandlerUtil.copyType(constructor.returnType, source);
        for (EclipseNode fieldNode : fields) {
            FieldDeclaration field = (FieldDeclaration)fieldNode.get();
            long fieldPos = (long)field.sourceStart << 32 | (long)field.sourceEnd;
            SingleNameReference nameRef = new SingleNameReference(field.name, fieldPos);
            assigns.add(nameRef);
            Argument parameter = new Argument(field.name, fieldPos, EclipseHandlerUtil.copyType(field.type, source), 16);
            Annotation[] copiedAnnotations = EclipseHandlerUtil.copyAnnotations(source, Eclipse.findAnnotations(field, HandlerUtil.NON_NULL_PATTERN), Eclipse.findAnnotations(field, HandlerUtil.NULLABLE_PATTERN));
            if (copiedAnnotations.length != 0) {
                parameter.annotations = copiedAnnotations;
            }
            params.add(parameter);
        }
        statement.arguments = assigns.isEmpty() ? null : assigns.toArray(new Expression[assigns.size()]);
        constructor.arguments = params.isEmpty() ? null : params.toArray(new Argument[params.size()]);
        constructor.statements = new Statement[]{new ReturnStatement((Expression)statement, (int)(p >> 32), (int)p)};
        constructor.traverse((ASTVisitor)new SetGeneratedByVisitor(source), typeDecl.scope);
        return constructor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SkipIfConstructorExists {
        YES,
        NO,
        I_AM_BUILDER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HandleAllArgsConstructor
    extends EclipseAnnotationHandler<AllArgsConstructor> {
        @Override
        public void handle(AnnotationValues<AllArgsConstructor> annotation, Annotation ast, EclipseNode annotationNode) {
            HandlerUtil.handleFlagUsage(annotationNode, ConfigurationKeys.ALL_ARGS_CONSTRUCTOR_FLAG_USAGE, "@AllArgsConstructor", ConfigurationKeys.ANY_CONSTRUCTOR_FLAG_USAGE, "any @xArgsConstructor");
            EclipseNode typeNode = (EclipseNode)annotationNode.up();
            if (!HandleConstructor.checkLegality(typeNode, annotationNode, AllArgsConstructor.class.getSimpleName())) {
                return;
            }
            AllArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            if (level == AccessLevel.NONE) {
                return;
            }
            String staticName = ann.staticName();
            Boolean suppressConstructorProperties = null;
            if (annotation.isExplicit("suppressConstructorProperties")) {
                boolean suppress = ann.suppressConstructorProperties();
                suppressConstructorProperties = suppress;
            }
            List<Annotation> onConstructor = EclipseHandlerUtil.unboxAndRemoveAnnotationParameter(ast, "onConstructor", "@AllArgsConstructor(onConstructor=", annotationNode);
            new HandleConstructor().generateConstructor(typeNode, level, HandleConstructor.findAllFields(typeNode), staticName, SkipIfConstructorExists.NO, suppressConstructorProperties, onConstructor, annotationNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HandleRequiredArgsConstructor
    extends EclipseAnnotationHandler<RequiredArgsConstructor> {
        @Override
        public void handle(AnnotationValues<RequiredArgsConstructor> annotation, Annotation ast, EclipseNode annotationNode) {
            HandlerUtil.handleFlagUsage(annotationNode, ConfigurationKeys.REQUIRED_ARGS_CONSTRUCTOR_FLAG_USAGE, "@RequiredArgsConstructor", ConfigurationKeys.ANY_CONSTRUCTOR_FLAG_USAGE, "any @xArgsConstructor");
            EclipseNode typeNode = (EclipseNode)annotationNode.up();
            if (!HandleConstructor.checkLegality(typeNode, annotationNode, RequiredArgsConstructor.class.getSimpleName())) {
                return;
            }
            RequiredArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            if (level == AccessLevel.NONE) {
                return;
            }
            String staticName = ann.staticName();
            Boolean suppressConstructorProperties = null;
            if (annotation.isExplicit("suppressConstructorProperties")) {
                boolean suppress = ann.suppressConstructorProperties();
                suppressConstructorProperties = suppress;
            }
            List<Annotation> onConstructor = EclipseHandlerUtil.unboxAndRemoveAnnotationParameter(ast, "onConstructor", "@RequiredArgsConstructor(onConstructor=", annotationNode);
            new HandleConstructor().generateConstructor(typeNode, level, HandleConstructor.findRequiredFields(typeNode), staticName, SkipIfConstructorExists.NO, suppressConstructorProperties, onConstructor, annotationNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HandleNoArgsConstructor
    extends EclipseAnnotationHandler<NoArgsConstructor> {
        @Override
        public void handle(AnnotationValues<NoArgsConstructor> annotation, Annotation ast, EclipseNode annotationNode) {
            HandlerUtil.handleFlagUsage(annotationNode, ConfigurationKeys.NO_ARGS_CONSTRUCTOR_FLAG_USAGE, "@NoArgsConstructor", ConfigurationKeys.ANY_CONSTRUCTOR_FLAG_USAGE, "any @xArgsConstructor");
            EclipseNode typeNode = (EclipseNode)annotationNode.up();
            if (!HandleConstructor.checkLegality(typeNode, annotationNode, NoArgsConstructor.class.getSimpleName())) {
                return;
            }
            NoArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            String staticName = ann.staticName();
            if (level == AccessLevel.NONE) {
                return;
            }
            ArrayList<EclipseNode> fields = new ArrayList<EclipseNode>();
            List<Annotation> onConstructor = EclipseHandlerUtil.unboxAndRemoveAnnotationParameter(ast, "onConstructor", "@NoArgsConstructor(onConstructor=", annotationNode);
            new HandleConstructor().generateConstructor(typeNode, level, fields, staticName, SkipIfConstructorExists.NO, null, onConstructor, annotationNode);
        }
    }
}

