/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.io;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Leaf;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.WriteOptions;
import org.gcube.data.trees.io.XMLBindings;

class XMLWriter {
    private static final XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    private final XMLStreamWriter writer;
    private final WriteOptions options;

    static {
        outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", new Boolean(true));
    }

    XMLWriter(Result result, WriteOptions options) {
        try {
            this.writer = outputFactory.createXMLStreamWriter(result);
            this.options = options;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void write(Tree tree) {
        try {
            this.writer.writeStartDocument();
            for (Map.Entry<String, String> decl : this.options.prefixes().entrySet()) {
                this.writer.setPrefix(decl.getKey(), decl.getValue());
            }
            QName root = this.options.rootElement();
            if (root.getPrefix().isEmpty()) {
                this.writer.writeStartElement(root.getNamespaceURI(), root.getLocalPart());
            } else {
                this.writer.writeStartElement(root.getPrefix(), root.getLocalPart(), root.getNamespaceURI());
            }
            this.writeAttributes(tree);
            if (tree.sourceId() != null) {
                this.writer.writeAttribute(XMLBindings.SOURCE.getNamespaceURI(), XMLBindings.SOURCE.getLocalPart(), tree.sourceId());
            }
            for (Edge e : tree.edges()) {
                if (e.target() instanceof InnerNode) {
                    this.writeInnerNode(e.label(), (InnerNode)e.target());
                    continue;
                }
                Leaf leaf = (Leaf)e.target();
                if (leaf.value() == null) {
                    this.writeEmptyLeaf(e.label(), leaf);
                    continue;
                }
                this.writeLeaf(e.label(), leaf);
            }
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void writeNode(Node node) {
        try {
            this.writer.writeStartDocument();
            if (node instanceof Leaf) {
                this.writeLeaf(this.options.rootElement(), (Leaf)node);
            } else {
                this.writeInnerNode(this.options.rootElement(), (InnerNode)node);
            }
            this.writer.writeEndDocument();
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeAttributes(Node node) throws Exception {
        for (Map.Entry<QName, String> attr : node.attributes().entrySet()) {
            if (attr.getValue() == null) continue;
            String prefix = attr.getKey().getPrefix();
            String ns = attr.getKey().getNamespaceURI();
            String name = attr.getKey().getLocalPart();
            String value = attr.getValue();
            if (!prefix.isEmpty()) {
                this.writer.writeAttribute(prefix, ns, name, value);
                continue;
            }
            if (!ns.isEmpty()) {
                this.writer.writeAttribute(ns, name, value);
                continue;
            }
            this.writer.writeAttribute(name, value);
        }
        if (node.id() != null) {
            this.writer.writeAttribute(XMLBindings.ID.getNamespaceURI(), XMLBindings.ID.getLocalPart(), node.id());
        }
        if (node.state() != null) {
            this.writer.writeAttribute(XMLBindings.STATE.getNamespaceURI(), XMLBindings.STATE.getLocalPart(), node.state().name());
        }
    }

    private void writeInnerNode(QName label, InnerNode node) throws Exception {
        if (!label.getPrefix().isEmpty()) {
            this.writer.writeStartElement(label.getPrefix(), label.getLocalPart(), label.getNamespaceURI());
        } else if (!label.getNamespaceURI().isEmpty()) {
            this.writer.writeStartElement(label.getNamespaceURI(), label.getLocalPart());
        } else {
            this.writer.writeStartElement(label.getLocalPart());
        }
        this.writeAttributes(node);
        for (Edge e : node.edges()) {
            if (e.target() instanceof InnerNode) {
                this.writeInnerNode(e.label(), (InnerNode)e.target());
                continue;
            }
            this.writeLeaf(e.label(), (Leaf)e.target());
        }
        this.writer.writeEndElement();
    }

    private void writeLeaf(QName label, Leaf leaf) throws Exception {
        if (!label.getPrefix().isEmpty()) {
            this.writer.writeStartElement(label.getPrefix(), label.getLocalPart(), label.getNamespaceURI());
        } else if (!label.getNamespaceURI().isEmpty()) {
            this.writer.writeStartElement(label.getNamespaceURI(), label.getLocalPart());
        } else {
            this.writer.writeStartElement(label.getLocalPart());
        }
        this.writeAttributes(leaf);
        this.writer.writeCharacters(leaf.value());
        this.writer.writeEndElement();
    }

    private void writeEmptyLeaf(QName label, Node leaf) throws Exception {
        if (!label.getPrefix().isEmpty()) {
            this.writer.writeEmptyElement(label.getPrefix(), label.getLocalPart(), label.getNamespaceURI());
        } else if (!label.getNamespaceURI().isEmpty()) {
            this.writer.writeEmptyElement(label.getNamespaceURI(), label.getLocalPart());
        } else {
            this.writer.writeEmptyElement(label.getLocalPart());
        }
        this.writer.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
        this.writeAttributes(leaf);
    }
}

