/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.repository;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRRepository {
    public static final String PATH_SEPARATOR = "/";
    public static final String ROOT_WEBDAV = "/repository/default/";
    public static final String HOME_FOLDER = "Home";
    public static final String SHARED_FOLDER = "Share";
    private static final String GCUBE_FOLDER = "GCube";
    private static final String DOWNLOADS = "Downloads";
    private static final String SMART_FOLDER = "Folders";
    private static final String IN_BOX_FOLDER = "InBox";
    private static final String OUT_BOX_FOLDER = "OutBox";
    private static final String SERVICENAME = "HomeLibraryWebapp";
    private static final String SERVICECLASS = "DataAccess";
    private String portalLogin;
    private static Repository repository;
    private static String webdavUrl;
    public static String serviceName;
    public static String HLversion;
    public static Map<String, GCoreEndpoint.Profile.Endpoint> servlets;
    private static Logger logger;

    static {
        logger = LoggerFactory.getLogger(JCRRepository.class);
    }

    public JCRRepository(User user) throws InternalErrorException {
        this.portalLogin = user.getPortalLogin();
        logger.info("getHome " + this.portalLogin);
        try {
            this.init();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private static synchronized void initializeRepository() throws InternalErrorException {
        if (repository != null) {
            return;
        }
        AuthorizationEntry entry = null;
        try {
            entry = Constants.authorizationService().get(SecurityTokenProvider.instance.get());
            if (entry.getContext() == null) {
                throw new IllegalArgumentException("context is null");
            }
            String context = Constants.authorizationService().get(SecurityTokenProvider.instance.get()).getContext();
            logger.debug("scope for repository creation is {} ", (Object)context);
            ScopeProvider.instance.set(context);
        }
        catch (Exception e1) {
            logger.info("NO TOKEN");
            String callerScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set(callerScope);
        }
        try {
            String version = "3";
            String minorVersion = "1";
            String revisionVersion = "1";
            HLversion = String.valueOf(version) + "." + minorVersion + "." + revisionVersion;
            webdavUrl = "https://www.d4science.org/Home";
            serviceName = "test-home-library";
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            query.addCondition(String.format("$resource/Profile/ServiceName/text() eq '%s' and $resource/Profile/ServiceClass/text() eq '%s' ", SERVICENAME, SERVICECLASS));
            DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
            List resources = client.submit((Query)query);
            if (resources.size() != 0) {
                try {
                    GCoreEndpoint resource = (GCoreEndpoint)resources.get(0);
                    servlets = resource.profile().endpointMap();
                }
                catch (Throwable e) {
                    logger.error("error decrypting resource", e);
                }
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public List<String> getHomeNames() throws RepositoryException {
        ArrayList<String> homes = new ArrayList<String>();
        JCRSession session = null;
        try {
            try {
                session = new JCRSession(this.portalLogin, false);
                ItemDelegate home = session.getItemByPath("/Home");
                List<ItemDelegate> children = session.getChildrenById(home.getId(), false);
                for (ItemDelegate child : children) {
                    if (!child.getPrimaryType().equals("nthl:home")) continue;
                    homes.add(child.getName());
                }
            }
            catch (ItemNotFoundException e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            session.releaseSession();
        }
        return homes;
    }

    public ItemDelegate getHome() throws RepositoryException {
        ItemDelegate home = null;
        JCRSession session = null;
        try {
            try {
                session = new JCRSession(this.portalLogin, false);
                home = session.getItemByPath("/Home");
            }
            catch (ItemNotFoundException e) {
                try {
                    home = this.getRootNode().addNode(HOME_FOLDER, "nt:folder");
                    session.saveItem(home);
                }
                catch (Exception e1) {
                    throw new RepositoryException(e1.getMessage());
                }
                if (session != null) {
                    session.releaseSession();
                }
            }
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
        return home;
    }

    public static synchronized void initialize() throws InternalErrorException {
        logger.debug("Initialize repository");
        JCRRepository.initializeRepository();
    }

    public void init() throws Exception {
        block18: {
            JCRUserManager um = new JCRUserManager();
            String userVersion = JCRRepository.getUserVersion(this.portalLogin, um);
            logger.info(String.valueOf(this.portalLogin) + " - USER VERSION: " + userVersion + " - HL VERSION: " + HLversion);
            if (!HLversion.equals(userVersion)) {
                JCRSession servlets = null;
                try {
                    try {
                        servlets = new JCRSession(this.portalLogin, false);
                        ItemDelegate home = this.getHome();
                        DelegateManager homeManager = new DelegateManager(home, this.portalLogin);
                        ItemDelegate userHome = null;
                        try {
                            userHome = homeManager.addNode(this.portalLogin, "nthl:home");
                            try {
                                homeManager.save(userHome);
                            }
                            catch (Exception e) {
                                logger.error("Impossible to create " + this.portalLogin);
                                throw new RepositoryException(e.getMessage());
                            }
                            um.createUser(this.portalLogin, HLversion);
                        }
                        catch (InternalErrorException e) {
                            userHome = homeManager.getNode(this.portalLogin);
                        }
                        DelegateManager userHomeManager = new DelegateManager(userHome, this.portalLogin);
                        try {
                            ItemDelegate smartFolder = userHomeManager.addNode(SMART_FOLDER, "nt:folder");
                            userHomeManager.save(smartFolder);
                        }
                        catch (Exception e) {
                            logger.error("Impossible to create Folders");
                        }
                        try {
                            ItemDelegate inBoxDelegate = userHomeManager.addNode(IN_BOX_FOLDER, "nthl:rootItemSentRequest");
                            userHomeManager.save(inBoxDelegate);
                        }
                        catch (Exception e) {
                            logger.error("Impossible to create InBox");
                        }
                        try {
                            ItemDelegate outBoxDelegate = userHomeManager.addNode(OUT_BOX_FOLDER, "nthl:rootItemSentRequest");
                            userHomeManager.save(outBoxDelegate);
                        }
                        catch (Exception e) {
                            logger.error("Impossible to create OutBox");
                        }
                        try {
                            ItemDelegate downloadFolder = userHomeManager.addNode(DOWNLOADS, "nthl:rootFolderBulkCreator");
                            userHomeManager.save(downloadFolder);
                        }
                        catch (Exception e) {
                            logger.error("Impossible to create Downloads");
                        }
                        break block18;
                    }
                    catch (RepositoryException e) {
                        throw new RepositoryException(e.getMessage());
                    }
                }
                finally {
                    servlets.releaseSession();
                }
            }
            logger.info("skip init in JCRRepository");
        }
    }

    public List<String> listScopes() throws RepositoryException, InternalErrorException {
        LinkedList<String> list = new LinkedList<String>();
        return list;
    }

    public ItemDelegate getGCubeRoot() throws RepositoryException, InternalErrorException {
        logger.info("getGCubeRoot");
        JCRSession servlet = null;
        ItemDelegate gcubeRoot = null;
        try {
            try {
                servlet = new JCRSession(this.portalLogin, false);
                try {
                    gcubeRoot = servlet.getItemByPath("/GCube");
                }
                catch (ItemNotFoundException e) {
                    gcubeRoot = this.getRootNode().addNode(GCUBE_FOLDER, "nt:folder");
                    servlet.saveItem(gcubeRoot);
                }
            }
            catch (Exception e) {
                logger.error("Error retrieving shared root");
                servlet.releaseSession();
            }
        }
        finally {
            servlet.releaseSession();
        }
        return gcubeRoot;
    }

    public ItemDelegate getSharedRoot() throws RepositoryException, InternalErrorException {
        logger.info("getSharedRoot");
        JCRSession servlet = null;
        ItemDelegate sharedNode = null;
        try {
            try {
                servlet = new JCRSession(this.portalLogin, false);
                try {
                    sharedNode = servlet.getItemByPath("/Share");
                }
                catch (Exception e) {
                    sharedNode = this.getRootNode().addNode(SHARED_FOLDER, "nt:folder");
                    servlet.saveItem(sharedNode);
                }
            }
            catch (RepositoryException e) {
                logger.error("Error retrieving shared root");
                servlet.releaseSession();
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlet.releaseSession();
        }
        return sharedNode;
    }

    private DelegateManager getRootNode() throws RepositoryException {
        JCRSession servlet = null;
        ItemDelegate root = null;
        DelegateManager wrap = null;
        try {
            try {
                servlet = new JCRSession(this.portalLogin, false);
                root = servlet.getItemByPath(PATH_SEPARATOR);
                wrap = new DelegateManager(root, "");
            }
            catch (Exception e) {
                logger.error("Error retrieving Root Node " + e.getMessage());
                servlet.releaseSession();
            }
        }
        finally {
            servlet.releaseSession();
        }
        return wrap;
    }

    public ItemDelegate getUserHome() throws RepositoryException, ItemNotFoundException {
        logger.info("getUserHome: /Home/" + this.portalLogin);
        ItemDelegate userHomeDelegate = null;
        JCRSession servlets = null;
        try {
            try {
                servlets = new JCRSession(this.portalLogin, false);
                userHomeDelegate = servlets.getItemByPath("/Home/" + this.portalLogin);
            }
            catch (RepositoryException e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            servlets.releaseSession();
        }
        return userHomeDelegate;
    }

    public ItemDelegate getRootSmartFolders() throws RepositoryException {
        ItemDelegate smartFolders = null;
        JCRSession servlets = null;
        try {
            try {
                servlets = new JCRSession(this.portalLogin, true);
                logger.info("getRootSmartFolders: /Home/" + this.portalLogin + PATH_SEPARATOR + SMART_FOLDER);
                try {
                    smartFolders = servlets.getItemByPath("/Home/" + this.portalLogin + PATH_SEPARATOR + SMART_FOLDER);
                }
                catch (ItemNotFoundException e) {
                    smartFolders = this.getUserHome(this.portalLogin).addNode(SMART_FOLDER, "nt:folder");
                    servlets.saveItem(smartFolders);
                }
            }
            catch (Exception e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            servlets.releaseSession();
        }
        return smartFolders;
    }

    private DelegateManager getUserHome(String user) throws InternalErrorException, RepositoryException {
        DelegateManager wrap = null;
        JCRSession servlets = null;
        try {
            try {
                servlets = new JCRSession(this.portalLogin, false);
                ItemDelegate item = servlets.getItemByPath("/Home/" + this.portalLogin);
                wrap = new DelegateManager(item, this.portalLogin);
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
        return wrap;
    }

    public ItemDelegate getOwnInBoxFolder() throws javax.jcr.RepositoryException {
        ItemDelegate inBoxNode = null;
        JCRSession servlets = null;
        try {
            try {
                servlets = new JCRSession(this.portalLogin, false);
                try {
                    inBoxNode = servlets.getItemByPath("/Home/" + this.portalLogin + PATH_SEPARATOR + IN_BOX_FOLDER);
                }
                catch (ItemNotFoundException e) {
                    inBoxNode = this.getUserHome(this.portalLogin).addNode(IN_BOX_FOLDER, "nthl:rootItemSentRequest");
                    servlets.saveItem(inBoxNode);
                }
            }
            catch (Exception e) {
                throw new javax.jcr.RepositoryException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
        return inBoxNode;
    }

    public ItemDelegate getOutBoxFolder() throws javax.jcr.RepositoryException {
        ItemDelegate outBoxNode = null;
        JCRSession servlets = null;
        logger.info("getOutBoxFolder: /Home/" + this.portalLogin + PATH_SEPARATOR + OUT_BOX_FOLDER);
        try {
            try {
                servlets = new JCRSession(this.portalLogin, false);
                try {
                    outBoxNode = servlets.getItemByPath("/Home/" + this.portalLogin + PATH_SEPARATOR + OUT_BOX_FOLDER);
                }
                catch (ItemNotFoundException e) {
                    outBoxNode = this.getUserHome(this.portalLogin).addNode(OUT_BOX_FOLDER, "nthl:rootItemSentRequest");
                    servlets.saveItem(outBoxNode);
                }
            }
            catch (Exception e) {
                throw new javax.jcr.RepositoryException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
        return outBoxNode;
    }

    public Node getRootFolderBulkCreators(Session session) throws javax.jcr.RepositoryException {
        Node downloads = null;
        logger.info("Get Download Folder: /Home/" + this.portalLogin + PATH_SEPARATOR + DOWNLOADS);
        if (downloads == null) {
            try {
                try {
                    downloads = session.getNode("/Home/" + this.portalLogin + PATH_SEPARATOR + DOWNLOADS);
                }
                catch (PathNotFoundException e) {
                    downloads = session.getNode("/Home/" + this.portalLogin).addNode(DOWNLOADS, "nthl:rootFolderBulkCreator");
                    session.save();
                }
            }
            catch (Exception e) {
                throw new javax.jcr.RepositoryException((Throwable)e);
            }
        }
        return downloads;
    }

    public ItemDelegate getInBoxFolder(String user) throws javax.jcr.RepositoryException, InternalErrorException {
        JCRSession servlets = null;
        ItemDelegate inBoxFolder = null;
        try {
            try {
                servlets = new JCRSession(this.portalLogin, false);
                inBoxFolder = servlets.getItemByPath("/Home/" + user + PATH_SEPARATOR + IN_BOX_FOLDER);
            }
            catch (Exception e) {
                throw new javax.jcr.RepositoryException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
        return inBoxFolder;
    }

    public String getWebDavUrl(String portalLogin) {
        return String.valueOf(webdavUrl) + PATH_SEPARATOR + portalLogin;
    }

    public static String getUserVersion(String portalLogin, JCRUserManager um) throws InternalErrorException {
        if (um == null) {
            um = new JCRUserManager();
        }
        String userVersion = um.getVersionByUser(portalLogin);
        return userVersion;
    }
}

