/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleOutputStream {
    private Logger logger = LoggerFactory.getLogger(MultipleOutputStream.class);
    MyPipedInputStream s1;
    MyPipedInputStream s2;
    InputStream is;
    MyPipedOututStream os1;
    MyPipedOututStream os2;

    public MultipleOutputStream(InputStream is) throws InternalErrorException, IOException {
        this.is = is;
        this.os1 = new MyPipedOututStream();
        this.os2 = new MyPipedOututStream();
        this.s1 = new MyPipedInputStream(this.os1);
        this.s2 = new MyPipedInputStream(this.os2);
    }

    public void startWriting() throws Exception {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedInputStream bis = new BufferedInputStream(this.is);){
                byte[] buf = new byte[65536];
                int read = -1;
                int writeTot = 0;
                while ((read = bis.read(buf)) != -1) {
                    if (!this.s1.isClosed()) {
                        this.os1.write(buf, 0, read);
                    }
                    if (!this.s2.isClosed()) {
                        this.os2.write(buf, 0, read);
                    }
                    writeTot += read;
                    if (this.os1.isClosed() && this.os2.isClosed()) break;
                }
                if (!this.os1.isClosed()) {
                    this.os1.close();
                }
                if (!this.os2.isClosed()) {
                    this.os2.close();
                }
                this.logger.info("total written " + writeTot);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public InputStream getS1() {
        return this.s1;
    }

    public InputStream getS2() {
        return this.s2;
    }

    public class MyPipedInputStream
    extends PipedInputStream {
        boolean close;

        public MyPipedInputStream(PipedOutputStream src) throws IOException {
            super(src);
            this.close = false;
        }

        @Override
        public void close() throws IOException {
            this.close = true;
            MultipleOutputStream.this.logger.info(String.valueOf(Thread.currentThread().getName()) + " close MyPipedInputStream");
            super.close();
        }

        public boolean isClosed() {
            return this.close;
        }
    }

    public class MyPipedOututStream
    extends PipedOutputStream {
        boolean close = false;

        @Override
        public void close() throws IOException {
            this.close = true;
            super.close();
        }

        public boolean isClosed() {
            return this.close;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                super.write(b, off, len);
            }
            catch (IOException io) {
                this.close = true;
            }
        }
    }
}

