/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.media;

import javax.xml.namespace.QName;
import org.apache.abdera.ext.media.MediaConstants;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ElementWrapper;

public class MediaRestriction
extends ElementWrapper {
    public MediaRestriction(Element internal) {
        super(internal);
    }

    public MediaRestriction(Factory factory) {
        super(factory, MediaConstants.RESTRICTION);
    }

    public void setRelationship(MediaConstants.Relationship type) {
        switch (type) {
            case ALLOW: {
                this.setAttributeValue("relationship", "allow");
                break;
            }
            case DENY: {
                this.setAttributeValue("relationship", "deny");
                break;
            }
            default: {
                this.removeAttribute(new QName("relationship"));
            }
        }
    }

    public MediaConstants.Relationship getRelationship() {
        String rel = this.getAttributeValue("relationship");
        return rel != null ? MediaConstants.Relationship.valueOf(rel.toUpperCase()) : null;
    }

    public void setType(MediaConstants.RestrictionType type) {
        switch (type) {
            case COUNTRY: {
                this.setAttributeValue("type", "country");
                break;
            }
            case URI: {
                this.setAttributeValue("type", "uri");
                break;
            }
            default: {
                this.removeAttribute(new QName("type"));
            }
        }
    }

    public MediaConstants.RestrictionType getType() {
        String type = this.getAttributeValue("type");
        return type != null ? MediaConstants.RestrictionType.valueOf(type.toUpperCase()) : null;
    }
}

