/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.serializer;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.serializer.Conventions;
import org.apache.abdera.ext.serializer.DefaultConventions;
import org.apache.abdera.ext.serializer.DefaultSerializationContext;
import org.apache.abdera.ext.serializer.SerializationException;
import org.apache.abdera.ext.serializer.Serializer;
import org.apache.abdera.writer.StreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConventionSerializationContext
extends DefaultSerializationContext {
    private static final long serialVersionUID = 7504071837124132972L;
    protected Conventions conventions;

    public ConventionSerializationContext(StreamWriter streamWriter) {
        this(new Abdera(), streamWriter);
    }

    public ConventionSerializationContext(Conventions conventions, StreamWriter streamWriter) {
        this(null, conventions, streamWriter);
    }

    public ConventionSerializationContext(Abdera abdera, StreamWriter streamWriter) {
        super(abdera, streamWriter);
        this.conventions = new DefaultConventions();
        this.initSerializers();
    }

    public ConventionSerializationContext(Abdera abdera, Conventions conventions, StreamWriter streamWriter) {
        super(abdera, streamWriter);
        this.conventions = conventions;
        this.initSerializers();
    }

    public Conventions getConventions() {
        return this.conventions;
    }

    public void setConventions(Conventions conventions) {
        this.conventions = conventions;
    }

    @Override
    public boolean hasSerializer(AccessibleObject accessor) {
        boolean answer = super.hasSerializer(accessor);
        if (answer) {
            return true;
        }
        Class<? extends Annotation> annotation = this.getConventions().matchConvention(accessor);
        return annotation != null && this.hasSerializer(annotation);
    }

    private <T> void initSerializers() {
        for (Class type : this.conventions) {
            org.apache.abdera.ext.serializer.annotation.Serializer serializer = type.getAnnotation(org.apache.abdera.ext.serializer.annotation.Serializer.class);
            if (serializer == null) continue;
            try {
                Serializer ser = serializer.value().newInstance();
                this.setSerializer(type, ser);
            }
            catch (Throwable t) {
                throw new SerializationException(t);
            }
        }
    }
}

