/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.serializer;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.abdera.ext.serializer.AbstractSerializationContext;
import org.apache.abdera.ext.serializer.Conventions;
import org.apache.abdera.ext.serializer.SerializationException;
import org.apache.abdera.ext.serializer.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectContext {
    private final Class objectType;
    private final Object parent;
    private final AccessibleObject accessor;
    private final Annotation[] annotations;
    private final Serializer serializer;
    private final Field[] fields;
    private final Method[] methods;

    public ObjectContext(Object object) {
        this(object, null, null);
    }

    public ObjectContext(Object object, Object parent, AccessibleObject accessor) {
        this.objectType = object != null ? object.getClass() : (accessor != null ? AbstractSerializationContext.getReturnType(accessor) : null);
        this.parent = parent;
        this.accessor = accessor;
        this.annotations = this.initAnnotations();
        this.serializer = this.initSerializer();
        this.fields = this.initFields();
        this.methods = this.initMethods();
    }

    private Field[] initFields() {
        Field[] fields = this.objectType.getFields();
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : fields) {
            int mods = field.getModifiers();
            if (Modifier.isStatic(mods)) continue;
            list.add(field);
        }
        return list.toArray(new Field[list.size()]);
    }

    private Method[] initMethods() {
        Method[] methods = this.objectType.getMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods) {
            int mods = method.getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isAbstract(mods) || method.getParameterTypes().length != 0 || method.getReturnType() == Void.class) continue;
            list.add(method);
        }
        return list.toArray(new Method[list.size()]);
    }

    private Annotation[] initAnnotations() {
        HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
        if (this.objectType != null) {
            for (Annotation annotation : this.objectType.getAnnotations()) {
                annotations.put(annotation.annotationType(), annotation);
            }
        }
        if (this.accessor != null) {
            for (Annotation annotation : this.accessor.getAnnotations()) {
                annotations.put(annotation.annotationType(), annotation);
            }
        }
        return annotations.values().toArray(new Annotation[annotations.size()]);
    }

    private Serializer initSerializer() {
        try {
            org.apache.abdera.ext.serializer.annotation.Serializer ser = this.getAnnotation(org.apache.abdera.ext.serializer.annotation.Serializer.class);
            if (ser != null) {
                Class<? extends Serializer> serclass = ser.value();
                return serclass.newInstance();
            }
            return null;
        }
        catch (Throwable t) {
            throw new SerializationException(t);
        }
    }

    public AccessibleObject getAccessor() {
        return this.accessor;
    }

    public Object getParent() {
        return this.parent;
    }

    public Class getObjectType() {
        return this.objectType;
    }

    public <X extends Annotation> X getAnnotation(Class<X> annotationType) {
        for (Annotation annotation : this.annotations) {
            if (annotation.annotationType() != annotationType) continue;
            return (X)annotation;
        }
        return null;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public AccessibleObject[] getAccessors() {
        ArrayList<AccessibleObject> list = new ArrayList<AccessibleObject>();
        for (Method method : this.methods) {
            list.add(method);
        }
        for (AccessibleObject accessibleObject : this.fields) {
            list.add(accessibleObject);
        }
        return list.toArray(new AccessibleObject[list.size()]);
    }

    public AccessibleObject[] getAccessors(Class<? extends Annotation> annotation, Conventions conventions) {
        ArrayList<AccessibleObject> accessors = new ArrayList<AccessibleObject>();
        for (AccessibleObject accessor : this.getAccessors()) {
            if (!accessor.isAnnotationPresent(annotation) && !annotation.equals(conventions.matchConvention(accessor))) continue;
            accessors.add(accessor);
        }
        return accessors.toArray(new AccessibleObject[accessors.size()]);
    }

    public AccessibleObject getAccessor(Class<? extends Annotation> annotation, Conventions conventions) {
        for (AccessibleObject accessor : this.getAccessors()) {
            if (!accessor.isAnnotationPresent(annotation) && !annotation.equals(conventions.matchConvention(accessor))) continue;
            return accessor;
        }
        return null;
    }
}

