/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.search.library.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySanitizer {
    private static Logger logger = LoggerFactory.getLogger(QuerySanitizer.class);
    static final Set<String> reservedKeywords = Sets.newHashSet((Object[])new String[]{"and", "or", "not", "prox", "fuse", "sortby", "project"});
    static final List<String> reservedSymbols = Lists.newArrayList((Object[])new String[]{",", ".", "-", "&", ")", "(", "]", "[", "=", "==", ">", "<", "<=", ">=", "<>", "/"});
    static final CharSequence reservedSymbolsCharset = Joiner.on((String)"").join(reservedSymbols);

    public static String sanitizeQuery(String query) {
        if (query == null) {
            return null;
        }
        List q = Splitter.on((String)"\"").trimResults().splitToList((CharSequence)query);
        if (q.size() % 2 != 1) {
            logger.warn("number of quotes should be even");
            throw new IllegalArgumentException("number of quotes should be even");
        }
        ArrayList sanitizedQuery = Lists.newArrayList();
        String subTerm = null;
        for (int i = 0; i != q.size(); ++i) {
            subTerm = (String)q.get(i);
            if (i % 2 == 0) {
                sanitizedQuery.addAll(QuerySanitizer.sanitizeSubQuery(subTerm));
                continue;
            }
            sanitizedQuery.add("\"" + subTerm + "\"");
        }
        return Joiner.on((String)" ").join((Iterable)sanitizedQuery);
    }

    static List<String> sanitizeSubQuery(String query) {
        String sanitized = query;
        String queryWithoutSymbols = CharMatcher.anyOf((CharSequence)reservedSymbolsCharset).replaceFrom((CharSequence)sanitized, (CharSequence)"");
        List terms = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().trimResults().splitToList((CharSequence)queryWithoutSymbols);
        ArrayList sanitizedTerms = Lists.newArrayList();
        for (String term : terms) {
            if (reservedKeywords.contains(term.toLowerCase())) {
                sanitizedTerms.add("\"" + term + "\"");
                continue;
            }
            sanitizedTerms.add(term);
        }
        return sanitizedTerms;
    }
}

