/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query;

import com.hp.hpl.jena.rdf.query.Printable;
import com.hp.hpl.jena.rdf.query.QueryFormatUtils;
import com.hp.hpl.jena.rdf.query.Settable;
import com.hp.hpl.jena.rdf.query.ValueException;
import java.io.PrintWriter;

public class WorkingVar
implements Printable,
Settable,
Cloneable {
    boolean isSet = false;
    boolean isInt = false;
    boolean isBoolean = false;
    boolean isLong = false;
    boolean isURI = false;
    boolean isString = false;
    int valInt;
    boolean valBoolean;
    long valLong;
    String valString;
    String valURI;

    public WorkingVar() {
        this.unset();
    }

    private void unset() {
        this.isSet = false;
        if (this.isString) {
            this.valString = null;
        }
        if (this.isURI) {
            this.valURI = null;
        }
        this.isInt = false;
        this.isBoolean = false;
        this.isLong = false;
        this.isURI = false;
        this.isString = false;
    }

    public void setInt(int n) {
        this.unset();
        this.isSet = true;
        this.isInt = true;
        this.valInt = n;
    }

    public void setLong(long l) {
        this.unset();
        this.isSet = true;
        this.isLong = true;
        this.valLong = l;
    }

    public void setBoolean(boolean bl) {
        this.unset();
        this.isSet = true;
        this.isBoolean = true;
        this.valBoolean = bl;
    }

    public void setString(String string) {
        this.unset();
        this.isSet = true;
        this.isString = true;
        this.valString = string;
    }

    public void setURI(String string) {
        this.unset();
        this.isSet = true;
        this.isURI = true;
        this.valURI = string;
    }

    public boolean isNumber() {
        this.forceInt();
        if (!this.isInt) {
            this.forceLong();
        }
        return this.isSet && (this.isInt || this.isLong);
    }

    public boolean isInt() {
        this.forceInt();
        return this.isSet && this.isInt;
    }

    public boolean isLong() {
        this.forceLong();
        return this.isSet && this.isLong;
    }

    public boolean isBoolean() {
        return this.isSet && this.isBoolean;
    }

    public boolean isString() {
        return this.isSet && this.isString;
    }

    public boolean isURI() {
        return this.isSet && this.isURI;
    }

    private void forceInt() {
        if (!this.isSet || this.isInt || !this.isString) {
            return;
        }
        try {
            this.valInt = Integer.parseInt(this.valString);
            this.isInt = true;
            this.isLong = true;
            this.valLong = this.valInt;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    private void forceLong() {
        if (!this.isSet || this.isLong || !this.isString) {
            return;
        }
        try {
            this.valLong = Long.parseLong(this.valString);
            this.isLong = true;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    public int getInt() {
        this.forceInt();
        if (!this.isSet || !this.isInt) {
            throw new ValueException("Not an int: " + this);
        }
        return this.valInt;
    }

    public long getLong() {
        this.forceLong();
        if (!this.isSet || !this.isLong) {
            throw new ValueException("Not a long: " + this);
        }
        return this.valLong;
    }

    public boolean getBoolean() {
        if (!this.isSet || !this.isBoolean) {
            throw new ValueException("Not a boolean: " + this);
        }
        return this.valBoolean;
    }

    public String getString() {
        if (!this.isSet) {
            return "<<unset>>";
        }
        if (this.isInt) {
            return Integer.toString(this.valInt);
        }
        if (this.isLong) {
            return Long.toString(this.valLong);
        }
        if (this.isURI) {
            return this.valURI;
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isString) {
            return this.valString;
        }
        return "<<unknown>>";
    }

    public String getURI() {
        if (!this.isSet || !this.isURI) {
            throw new ValueException("Not a URI: " + this);
        }
        return this.valURI;
    }

    public String asInfixString() {
        return this.asQuotedString();
    }

    public String asQuotedString() {
        if (!this.isSet) {
            return "<<unset>>";
        }
        if (this.isInt) {
            return Integer.toString(this.valInt);
        }
        if (this.isLong) {
            return Long.toString(this.valLong);
        }
        if (this.isURI) {
            return "<" + this.valURI + ">";
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isString) {
            return "\"" + this.valString + "\"";
        }
        return "<<unknown>>";
    }

    public String asPrefixString() {
        return this.asStringWithType();
    }

    private String asStringWithType() {
        if (!this.isSet) {
            return "<<unset>>";
        }
        if (this.isInt) {
            return "int:" + Integer.toString(this.valInt);
        }
        if (this.isLong) {
            return "long:" + Long.toString(this.valLong);
        }
        if (this.isURI) {
            return "URI:" + this.valURI;
        }
        if (this.isBoolean) {
            return "boolean:" + (this.valBoolean ? "true" : "false");
        }
        if (this.isString) {
            return "string:" + this.valString;
        }
        return "<<unknown>>";
    }

    public void print(PrintWriter printWriter, int n) {
        QueryFormatUtils.indent(printWriter, n);
        printWriter.println(this.asPrefixString());
    }

    public String asUnquotedString() {
        return this.getString();
    }

    public String toString() {
        return this.getString();
    }
}

