/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.mesa.rdf.jena.common.LiteralImpl;
import com.hp.hpl.mesa.rdf.jena.common.StatementImpl;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.DBConnection;
import com.hp.hpl.mesa.rdf.jena.rdb.DriverGenericGeneric;
import com.hp.hpl.mesa.rdf.jena.rdb.IConstraints;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.IRDBDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.ModelRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.PropertyImplRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.SQLCache;
import com.hp.hpl.mesa.rdf.jena.rdb.StoreRDB;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestStoreRDB
extends TestCase {
    protected DBConnection m_dbcon;
    protected String m_layout;
    protected String m_database;
    protected IRDBDriver m_driver;
    protected StoreRDB store;
    protected ModelRDB model;
    Property p1;
    Property p2;
    Property p3;
    Resource foo;
    Resource bar;
    Resource anon;

    public TestStoreRDB(String string, String string2, String string3) {
        super(string);
        this.m_layout = string2;
        this.m_database = string3;
        String string4 = System.getProperty("jena.rdb.test.dbfull");
        String string5 = System.getProperty("jena.rdb.test.user", "DER");
        String string6 = System.getProperty("jena.rdb.test.password", "key");
        this.m_dbcon = new DBConnection(string4, string5, string6);
    }

    public void setUp() throws RDFRDBException {
        this.m_driver = this.m_dbcon.getDriver(this.m_layout, this.m_database);
        if (this.m_driver.isDBFormatOK()) {
            this.m_driver.close();
            this.m_driver.cleanDB();
            this.m_driver.close();
        }
        this.store = StoreRDB.createDB(this.m_driver);
    }

    public void tearDown() throws SQLException, RDFRDBException {
        this.m_driver.close();
        this.m_driver.cleanDB();
        this.m_driver.close();
    }

    public void createModel(boolean bl) throws RDFException {
        this.model = new ModelRDB(this.store);
        this.p1 = this.model.createProperty("http://namespace/myprops#prop1");
        this.p2 = this.model.createProperty("http://namespace/myprops#prop2");
        this.p3 = this.model.createProperty("http://namespace/myprops#prop3");
        if (bl) {
            this.m_driver.hintPropertyTable(this.p1);
            this.m_driver.hintPropertyTable(this.p3);
        }
        this.anon = this.model.createResource().addProperty(this.p3, 13L);
        this.bar = this.model.createResource("http://namespace/mine#bar").addProperty(this.p2, "fred").addProperty(this.p3, 50L);
        this.foo = this.model.createResource("http://namespace/mine#foo").addProperty(this.p1, 50L).addProperty(this.p1, this.anon).addProperty(this.p1, this.bar);
    }

    public void clearModel() throws RDFException {
        StmtIterator stmtIterator = this.model.listStatements();
        while (stmtIterator.hasNext()) {
            stmtIterator.next();
            stmtIterator.remove();
        }
        stmtIterator.close();
    }

    public void testStore() throws SQLException, RDFException {
        this.createModel(false);
        this.doTestListNamespaces();
        this.doTestListStatements();
        this.doTestConstraints();
        this.doTestListSubjects();
        this.doTestMultipleAssert();
        this.doTestMultipleResources();
        this.doTestLangAttrib();
        this.doTestSQLCachePS();
        this.doTestDeleteStatement();
    }

    public void testStoreHint() throws SQLException, RDFException {
        this.createModel(true);
        this.doTestListNamespaces();
        this.doTestListStatements();
        this.doTestConstraints();
        this.doTestListSubjects();
        this.doTestMultipleAssert();
        this.doTestMultipleResources();
        this.doTestLangAttrib();
        this.doTestSQLCachePS();
        this.doTestDeleteStatement();
    }

    public void doTestListSubjects() throws SQLException, RDFException {
        ResultSetIterator resultSetIterator = this.m_driver.listSubjects(this.model);
        this.isResourceListOK(resultSetIterator, new Resource[]{this.bar, this.foo, this.anon});
    }

    public void doTestListNamespaces() throws RDFException, SQLException {
        Property property = this.model.createProperty("http://todie#baz");
        com.hp.hpl.mesa.rdf.jena.model.Statement statement = this.model.createStatement(this.foo, property, this.foo);
        this.model.add(statement);
        ResultSetIterator resultSetIterator = this.m_driver.listNamespaces(this.model);
        Assert.assertEquals((Object)"http://namespace/myprops#", resultSetIterator.next());
        Assert.assertEquals((Object)"http://todie#", resultSetIterator.next());
        Assert.assertTrue((!resultSetIterator.hasNext() ? (byte)1 : 0) != 0);
        this.model.remove(statement);
        resultSetIterator = this.m_driver.listNamespaces(this.model);
        Assert.assertEquals((Object)"http://namespace/myprops#", resultSetIterator.next());
        Assert.assertTrue((!resultSetIterator.hasNext() ? (byte)1 : 0) != 0);
    }

    public void doTestListStatements() throws RDFException, SQLException {
        ResultSetIterator resultSetIterator = this.m_driver.listStatements(null, null, null, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.anon, this.p3, new LiteralImpl("13")), new StatementImpl(this.bar, this.p2, new LiteralImpl("fred")), new StatementImpl(this.bar, this.p3, new LiteralImpl("50")), new StatementImpl(this.foo, this.p1, new LiteralImpl("50")), new StatementImpl(this.foo, this.p1, this.anon), new StatementImpl(this.foo, this.p1, this.bar)});
        resultSetIterator = this.m_driver.listStatements(this.foo, null, null, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.foo, this.p1, new LiteralImpl("50")), new StatementImpl(this.foo, this.p1, this.anon), new StatementImpl(this.foo, this.p1, this.bar)});
        resultSetIterator = this.m_driver.listStatements(null, this.p3, null, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.anon, this.p3, new LiteralImpl("13")), new StatementImpl(this.bar, this.p3, new LiteralImpl("50"))});
        resultSetIterator = this.m_driver.listStatements(this.bar, this.p3, null, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.bar, this.p3, new LiteralImpl("50"))});
        resultSetIterator = this.m_driver.listStatements(null, null, this.bar, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.foo, this.p1, this.bar)});
        resultSetIterator = this.m_driver.listStatements(null, null, this.model.createLiteral(50L), this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.bar, this.p3, new LiteralImpl("50")), new StatementImpl(this.foo, this.p1, new LiteralImpl("50"))});
        resultSetIterator = this.m_driver.listStatements(this.bar, null, this.model.createLiteral(50L), this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.bar, this.p3, new LiteralImpl("50"))});
        resultSetIterator = this.m_driver.listStatements(null, this.p3, this.model.createLiteral(50L), this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.bar, this.p3, new LiteralImpl("50"))});
        resultSetIterator = this.m_driver.listStatements(this.bar, this.p3, this.model.createLiteral(50L), this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.bar, this.p3, new LiteralImpl("50"))});
        resultSetIterator = this.m_driver.listStatements(this.foo, this.p1, this.bar, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.foo, this.p1, this.bar)});
        resultSetIterator = this.m_driver.listStatements(this.bar, this.p3, this.model.createLiteral(120L), this.model);
        Assert.assertTrue((!resultSetIterator.hasNext() ? (byte)1 : 0) != 0);
    }

    public void doTestConstraints() throws RDFException, SQLException {
        IConstraints iConstraints = this.m_driver.createConstraints(this.model);
        ResultSetIterator resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.anon, this.p3, new LiteralImpl("13")), new StatementImpl(this.bar, this.p2, new LiteralImpl("fred")), new StatementImpl(this.bar, this.p3, new LiteralImpl("50")), new StatementImpl(this.foo, this.p1, new LiteralImpl("50")), new StatementImpl(this.foo, this.p1, this.anon), new StatementImpl(this.foo, this.p1, this.bar)});
        iConstraints.reset().addSubjectConstraint(this.foo);
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.foo, this.p1, new LiteralImpl("50")), new StatementImpl(this.foo, this.p1, this.anon), new StatementImpl(this.foo, this.p1, this.bar)});
        iConstraints.reset().addPropertyConstraint(this.p3);
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.anon, this.p3, new LiteralImpl("13")), new StatementImpl(this.bar, this.p3, new LiteralImpl("50"))});
        iConstraints.reset().addSubjectConstraint(this.bar).addPropertyConstraint(this.p3);
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.bar, this.p3, new LiteralImpl("50"))});
        iConstraints.reset().addObjectConstraint(this.bar);
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.foo, this.p1, this.bar)});
        iConstraints.reset().addObjectConstraint(this.model.createLiteral(50L));
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.bar, this.p3, new LiteralImpl("50")), new StatementImpl(this.foo, this.p1, new LiteralImpl("50"))});
        iConstraints.reset().addSubjectConstraint(this.bar).addObjectConstraint(this.model.createLiteral(50L));
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.bar, this.p3, new LiteralImpl("50"))});
        iConstraints.reset().addPropertyConstraint(this.p3).addObjectConstraint(this.model.createLiteral(50L));
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.bar, this.p3, new LiteralImpl("50"))});
        iConstraints.reset().addSubjectConstraint(this.bar).addPropertyConstraint(this.p3).addObjectConstraint(this.model.createLiteral(50L));
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.bar, this.p3, new LiteralImpl("50"))});
        iConstraints.reset().addSubjectConstraint(this.foo).addPropertyConstraint(this.p1).addObjectConstraint(this.bar);
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.foo, this.p1, this.bar)});
        iConstraints.reset().addSubjectConstraint(this.bar).addPropertyConstraint(this.p3).addObjectConstraint(this.model.createLiteral(120L));
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        Assert.assertTrue((!resultSetIterator.hasNext() ? (byte)1 : 0) != 0);
        Property property = this.model.createProperty("http://namespace/myprops#prop4");
        this.foo.addProperty(property, "foo");
        this.foo.addProperty(property, "foobar");
        this.foo.addProperty(property, "bar");
        this.foo.addProperty(property, "foo27bar");
        this.foo.addProperty(property, "27");
        iConstraints.reset().addSubjectConstraint(this.foo).addPropertyConstraint(property).addStringConstraint("LIKE", "foo%");
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.foo, property, new LiteralImpl("foo")), new StatementImpl(this.foo, property, new LiteralImpl("foobar")), new StatementImpl(this.foo, property, new LiteralImpl("foo27bar"))});
        iConstraints.reset().addSubjectConstraint(this.foo).addPropertyConstraint(property).addStringConstraint("NOT LIKE", "%foo%");
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.foo, property, new LiteralImpl("bar")), new StatementImpl(this.foo, property, new LiteralImpl("27"))});
        iConstraints.reset().addSubjectConstraint(this.foo).addPropertyConstraint(property).addStringConstraint("LIKE", "foo%").addStringConstraint("NOT LIKE", "%27%");
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.foo, property, new LiteralImpl("foo")), new StatementImpl(this.foo, property, new LiteralImpl("foobar"))});
        this.foo.addProperty(property, 3L);
        this.foo.addProperty(property, 4L);
        this.foo.addProperty(property, 42L);
        this.foo.addProperty(property, 43L);
        iConstraints.reset().addSubjectConstraint(this.foo).addPropertyConstraint(property).addIntConstraint("<", 27);
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.foo, property, new LiteralImpl("3")), new StatementImpl(this.foo, property, new LiteralImpl("4"))});
        iConstraints.reset().addSubjectConstraint(this.foo).addPropertyConstraint(property).addIntConstraint(">=", 27);
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.foo, property, new LiteralImpl("27")), new StatementImpl(this.foo, property, new LiteralImpl("42")), new StatementImpl(this.foo, property, new LiteralImpl("43"))});
        iConstraints.reset().addSubjectConstraint(this.foo).addPropertyConstraint(property).addIntConstraint("<=", 42).addIntConstraint(">", 4);
        resultSetIterator = this.m_driver.listStatements(iConstraints, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.foo, property, new LiteralImpl("27")), new StatementImpl(this.foo, property, new LiteralImpl("42"))});
    }

    public void doTestDeleteStatement() throws RDFException {
        int n = this.store.size();
        this.foo.addProperty(this.p2, this.bar);
        this.foo.addProperty(this.p2, "42");
        Assert.assertEquals((int)(n + 2), (int)this.store.size());
        ResultSetIterator resultSetIterator = this.m_driver.listStatements(this.foo, this.p2, null, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.foo, this.p2, this.bar), new StatementImpl(this.foo, this.p2, new LiteralImpl("42"))});
        this.m_driver.deleteStatement(this.foo, this.p2, this.bar, this.model);
        resultSetIterator = this.m_driver.listStatements(this.foo, this.p2, null, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(this.foo, this.p2, new LiteralImpl("42"))});
        this.m_driver.deleteStatement(this.foo, this.p2, new LiteralImpl("42"), this.model);
        resultSetIterator = this.m_driver.listStatements(this.foo, this.p2, null, this.model);
        Assert.assertTrue((!resultSetIterator.hasNext() ? (byte)1 : 0) != 0);
        Assert.assertEquals((int)n, (int)this.store.size());
    }

    public void doTestSQLCachePS() throws SQLException, RDFRDBException {
        SQLCache sQLCache = this.m_driver.getSQLCache();
        IDBID iDBID = ((DriverGenericGeneric)this.m_driver).addNamespace("foobar");
        PreparedStatement preparedStatement = sQLCache.getPreparedSQLStatement("getNamespace");
        PreparedStatement preparedStatement2 = sQLCache.getPreparedSQLStatement("getNamespace");
        preparedStatement.setObject(1, iDBID.getID());
        preparedStatement2.setInt(1, 50);
        ResultSet resultSet = preparedStatement.executeQuery();
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"foobar", (Object)resultSet.getString(1));
        resultSet.close();
        sQLCache.returnPreparedSQLStatement(preparedStatement, "getNamespace");
        sQLCache.returnPreparedSQLStatement(preparedStatement2, "getNamespace");
        PreparedStatement preparedStatement3 = sQLCache.getPreparedSQLStatement("getNamespace");
        if (sQLCache.getCachePreparedStatements()) {
            Assert.assertEquals((String)"PS realloc", (Object)preparedStatement, (Object)preparedStatement3);
        }
    }

    public void doTestMultipleAssert() throws RDFException, SQLException {
        long l = this.model.size();
        com.hp.hpl.mesa.rdf.jena.model.Statement statement = this.model.createStatement(this.foo, this.p3, this.model.createLiteral("check"));
        this.model.add(statement);
        Assert.assertEquals((String)"Assert once", (long)(l + 1L), (long)this.model.size());
        this.model.add(statement);
        Assert.assertEquals((String)"Assert second time", (long)(l + 1L), (long)this.model.size());
        this.model.remove(statement);
        Assert.assertEquals((String)"Removed assertions", (long)l, (long)this.model.size());
    }

    public void doTestMultipleResources() throws RDFException {
        long l = this.model.size();
        Property property = this.model.createProperty("http://ns1/", "p");
        Property property2 = this.model.createProperty("http://ns2/", "p");
        this.foo.addProperty(property, true);
        this.foo.addProperty(property2, true);
        Assert.assertTrue((((PropertyImplRDB)property).getRDBId() != ((PropertyImplRDB)property2).getRDBId() ? (byte)1 : 0) != 0);
    }

    public void doTestLangAttrib() throws RDFException {
        Resource resource = this.model.createResource("http://namespace#fred");
        Property property = this.model.createProperty("http://namespace#fred");
        resource.addProperty(property, "foo", "fr");
        resource.addProperty(property, "foobar");
        ResultSetIterator resultSetIterator = this.m_driver.listStatements(resource, property, null, this.model);
        this.isStatementListOK(resultSetIterator, new com.hp.hpl.mesa.rdf.jena.model.Statement[]{new StatementImpl(resource, property, new LiteralImpl("foo", "fr")), new StatementImpl(resource, property, new LiteralImpl("foobar"))});
        StmtIterator stmtIterator = resource.listProperties(property);
        while (stmtIterator.hasNext()) {
            com.hp.hpl.mesa.rdf.jena.model.Statement statement = stmtIterator.next();
            stmtIterator.remove();
        }
        stmtIterator = resource.listProperties(property);
        Assert.assertTrue((!stmtIterator.hasNext() ? (byte)1 : 0) != 0);
    }

    protected void isResourceOK(Resource resource, Resource resource2) throws RDFException {
        if (resource2.isAnon()) {
            Assert.assertTrue((boolean)resource.isAnon());
            Assert.assertEquals((Object)resource2.getId(), (Object)resource.getId());
        } else {
            Assert.assertEquals((Object)resource2.getURI(), (Object)resource.getURI());
        }
    }

    protected void isResourceListOK(Iterator iterator, Resource[] resourceArray) throws RDFException {
        boolean[] blArray = new boolean[resourceArray.length];
        int n = 0;
        while (n < blArray.length) {
            blArray[n] = false;
            ++n;
        }
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            boolean bl = false;
            int n2 = 0;
            while (n2 < resourceArray.length) {
                if (!blArray[n2]) {
                    if (resource.isAnon()) {
                        if (resourceArray[n2].isAnon() && resourceArray[n2].getId().equals(resource.getId())) {
                            bl = true;
                        }
                    } else if (!resourceArray[n2].isAnon() && resourceArray[n2].getURI().equals(resource.getURI())) {
                        bl = true;
                    }
                    if (bl) {
                        blArray[n2] = true;
                        break;
                    }
                }
                ++n2;
            }
            Assert.assertTrue((boolean)bl);
        }
        int n3 = 0;
        while (n3 < resourceArray.length) {
            Assert.assertTrue((boolean)blArray[n3]);
            ++n3;
        }
    }

    protected void isStatementListOK(Iterator iterator, com.hp.hpl.mesa.rdf.jena.model.Statement[] statementArray) throws RDFException {
        boolean[] blArray = new boolean[statementArray.length];
        int n = 0;
        while (n < blArray.length) {
            blArray[n] = false;
            ++n;
        }
        while (iterator.hasNext()) {
            com.hp.hpl.mesa.rdf.jena.model.Statement statement = (com.hp.hpl.mesa.rdf.jena.model.Statement)iterator.next();
            boolean bl = false;
            int n2 = 0;
            while (n2 < statementArray.length) {
                if (!blArray[n2] && statement.equals(statementArray[n2])) {
                    bl = true;
                }
                if (bl) {
                    blArray[n2] = true;
                    break;
                }
                ++n2;
            }
            Assert.assertTrue((boolean)bl);
        }
        int n3 = 0;
        while (n3 < statementArray.length) {
            Assert.assertTrue((boolean)blArray[n3]);
            ++n3;
        }
    }

    protected void isStatementOK(com.hp.hpl.mesa.rdf.jena.model.Statement statement, Resource resource, Property property, Object object) throws RDFException {
        this.isResourceOK(statement.getSubject(), resource);
        this.isResourceOK(statement.getPredicate(), property);
        RDFNode rDFNode = statement.getObject();
        if (object instanceof String) {
            Assert.assertTrue((boolean)(rDFNode instanceof Literal));
            Assert.assertEquals((Object)object, (Object)((Literal)rDFNode).toString());
        } else {
            Assert.assertTrue((boolean)(rDFNode instanceof Resource));
            this.isResourceOK((Resource)rDFNode, (Resource)object);
        }
    }

    public void listTable(String string) throws SQLException, RDFRDBException {
        System.out.println("Table - " + string);
        Statement statement = this.m_driver.getConnection().createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM " + string);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = 1;
        while (n <= resultSetMetaData.getColumnCount()) {
            System.out.print("\t" + resultSetMetaData.getColumnLabel(n));
            ++n;
        }
        System.out.println("");
        while (resultSet.next()) {
            int n2 = 1;
            while (n2 <= resultSetMetaData.getColumnCount()) {
                System.out.print("\t" + resultSet.getObject(n2));
                ++n2;
            }
            System.out.println("");
        }
    }

    public static TestSuite suite(String string, String string2) {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestStoreRDB("testStore", string, string2));
        testSuite.addTest((Test)new TestStoreRDB("testStoreHint", string, string2));
        return testSuite;
    }
}

